/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HibernateEpr
extends EPR {
    public static final String LOAD_LISTENER = "loadListener";
    public static final String SAVE_LISTENER = "saveListener";
    public static final String DELETE_LISTENER = "deleteListener";
    public static final String CLASS_NAME_TAG = "classname";
    public static final String EVENT_TAG = "event";
    public static final String HIBERNATE_CFG_TAG = "hibernate-cfg-file";
    public static final String MESSAGE_FIELD_TAG = "message-field";
    public static final String STATUS_FIELD_TAG = "status-field";
    public static final String DATA_FIELD_TAG = "data-field";
    public static final String TIMESTAMP_FIELD_TAG = "insert-timestamp-field";
    public static final String POST_DEL_TAG = "postDelete";
    public static final String ERROR_DEL_TAG = "errorDelete";
    public static final String DEFAULT_REPLY_TO_CLASS_SUFFIX = "_reply_table";
    private boolean loadListener = true;
    private boolean saveListener = true;
    private boolean deleteListener = true;
    private boolean cfgFileSet = false;
    private boolean classNameSet = false;
    private boolean statusSet = false;
    private boolean messageSet = false;
    private boolean timestampSet = false;
    private boolean dataSet = false;
    private static URI m_type;

    public HibernateEpr(EPR epr) {
        super(epr);
        if (epr instanceof HibernateEpr) {
            HibernateEpr instance = (HibernateEpr)epr;
            this.cfgFileSet = instance.cfgFileSet;
            this.classNameSet = instance.classNameSet;
            this.statusSet = instance.statusSet;
            this.messageSet = instance.messageSet;
            this.timestampSet = instance.timestampSet;
            this.dataSet = instance.dataSet;
        }
    }

    public HibernateEpr(EPR epr, Element header) {
        super(epr);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                String tag = nl.item(i).getLocalName();
                if (tag == null) continue;
                if (tag.equals(HIBERNATE_CFG_TAG)) {
                    this.setHibernateCfgFile(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(CLASS_NAME_TAG)) {
                    this.setClassName(nl.item(i).getTextContent());
                    continue;
                }
                if (!tag.equals(EVENT_TAG)) continue;
                this.setEvent(nl.item(i).getTextContent());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public PortReference getAddr() {
        return super.getAddr();
    }

    public void setAddr(PortReference uri) {
        super.setAddr(uri);
    }

    public final String getHibernateCfgFile() {
        return this.getAddr().getExtensionValue(HIBERNATE_CFG_TAG);
    }

    public final void setHibernateCfgFile(String cfgFile) throws URISyntaxException {
        if (cfgFile == null) {
            throw new IllegalArgumentException();
        }
        if (this.cfgFileSet) {
            throw new IllegalStateException("Table name already set.");
        }
        this.getAddr().addExtension(HIBERNATE_CFG_TAG, cfgFile);
        this.cfgFileSet = true;
    }

    public final void setClassName(String className) throws URISyntaxException {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        if (this.classNameSet) {
            throw new IllegalStateException("Table name already set.");
        }
        this.getAddr().addExtension(CLASS_NAME_TAG, className);
        this.classNameSet = true;
    }

    public final String getClassName() {
        return this.getAddr().getExtensionValue(CLASS_NAME_TAG);
    }

    public final void setEvent(String eventName) throws URISyntaxException {
        if (eventName == null) {
            throw new IllegalArgumentException();
        }
        if (this.classNameSet) {
            throw new IllegalStateException("Table name already set.");
        }
        this.getAddr().addExtension(EVENT_TAG, eventName);
        this.classNameSet = true;
    }

    public final String getEvent() {
        return this.getAddr().getExtensionValue(EVENT_TAG);
    }

    public final void setStatusField(String statusField) throws URISyntaxException {
        if (statusField == null) {
            throw new IllegalArgumentException();
        }
        if (this.statusSet) {
            throw new IllegalStateException("Status column already set.");
        }
        this.getAddr().addExtension(STATUS_FIELD_TAG, statusField);
        this.statusSet = true;
    }

    public final String getStatusField() {
        return this.getAddr().getExtensionValue(STATUS_FIELD_TAG);
    }

    public final void setMessageField(String messageFieldName) throws URISyntaxException {
        if (messageFieldName == null) {
            throw new IllegalArgumentException();
        }
        if (this.messageSet) {
            throw new IllegalStateException("Message Id column already set.");
        }
        this.getAddr().addExtension(MESSAGE_FIELD_TAG, messageFieldName);
        this.messageSet = true;
    }

    public final String getMessageField() {
        return this.getAddr().getExtensionValue(MESSAGE_FIELD_TAG);
    }

    public final void setTimestampField(String timeField) throws URISyntaxException {
        if (timeField == null) {
            throw new IllegalArgumentException();
        }
        if (this.timestampSet) {
            throw new IllegalStateException("Timestamp column already set.");
        }
        this.getAddr().addExtension(TIMESTAMP_FIELD_TAG, timeField);
        this.timestampSet = true;
    }

    public final String getTimestampColumn() {
        return this.getAddr().getExtensionValue(TIMESTAMP_FIELD_TAG);
    }

    public final void setDataField(String dataField) throws URISyntaxException {
        if (dataField == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataSet) {
            throw new IllegalStateException("Data field already set.");
        }
        this.getAddr().addExtension(DATA_FIELD_TAG, dataField);
        this.dataSet = true;
    }

    public final String getDataField() {
        return this.getAddr().getExtensionValue(DATA_FIELD_TAG);
    }

    public boolean isDeleteListener() {
        return this.deleteListener;
    }

    public void setDeleteListener(boolean deleteListener) {
        this.deleteListener = deleteListener;
    }

    public boolean isLoadListener() {
        return this.loadListener;
    }

    public void setLoadListener(boolean loadListener) {
        this.loadListener = loadListener;
    }

    public boolean isSaveListener() {
        return this.saveListener;
    }

    public void setSaveListener(boolean saveListener) {
        this.saveListener = saveListener;
    }

    public String toString() {
        return "HibernateEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public EPR copy() {
        return new HibernateEpr(this);
    }

    protected final void changeClassName(String className) throws URISyntaxException {
        this.classNameSet = false;
        super.getAddr().removeExtension(CLASS_NAME_TAG, this.getClassName());
        this.setClassName(className);
    }

    public static final URI type() {
        return m_type;
    }

    static {
        try {
            m_type = new URI("urn:jboss/esb/epr/type/hibernate");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

