/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FTPSEpr
extends FTPEpr {
    public static final String CERTIFICATE_TAG = "certificate";
    public static final String CERTIFICATE_NAME_TAG = "certificateName";
    private boolean certificateSet = false;
    private boolean certificateNameSet;
    private static URI _type;

    public FTPSEpr(EPR epr) {
        super(epr);
        if (epr instanceof FTPSEpr) {
            this.certificateSet = ((FTPSEpr)epr).certificateSet;
            this.certificateNameSet = ((FTPSEpr)epr).certificateNameSet;
        }
    }

    public FTPSEpr(EPR epr, Element header) {
        super(epr, header);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String prefix = nl.item(i).getPrefix();
            String tag = nl.item(i).getLocalName();
            try {
                if (prefix == null || !prefix.equals("jbossesb")) continue;
                if (tag != null && tag.equals(CERTIFICATE_TAG)) {
                    this.getAddr().addExtension(CERTIFICATE_TAG, nl.item(i).getTextContent());
                    this.certificateSet = true;
                    continue;
                }
                if (tag == null || !tag.equals(CERTIFICATE_NAME_TAG)) continue;
                this.setCertificateName(nl.item(i).getTextContent());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public FTPSEpr(URI uri) throws URISyntaxException {
        super(uri);
    }

    public FTPSEpr(URI uri, URI cert, String name) throws URISyntaxException {
        super(uri);
        if (cert != null) {
            this.setCertificateURI(cert);
        }
        if (name != null) {
            this.setCertificateName(name);
        }
    }

    public FTPSEpr(URI uri, String cert, String name) throws URISyntaxException {
        super(uri);
        if (cert != null) {
            this.setCertificateURI(new URI(cert));
        }
        if (name != null) {
            this.setCertificateName(name);
        }
    }

    public FTPSEpr(String uri, String cert, String name) throws URISyntaxException {
        super(uri);
        if (cert != null) {
            this.setCertificateURI(new URI(cert));
        }
        if (name != null) {
            this.setCertificateName(name);
        }
    }

    public final void setCertificateURI(URI cert) throws URISyntaxException {
        if (cert == null) {
            throw new IllegalArgumentException();
        }
        if (this.certificateSet) {
            throw new IllegalStateException("Certificate URI already set.");
        }
        this.getAddr().addExtension(CERTIFICATE_TAG, cert.toASCIIString());
        this.certificateSet = true;
    }

    public final URI getCertificateURI() throws URISyntaxException {
        String cert = this.getAddr().getExtensionValue(CERTIFICATE_TAG);
        if (cert != null) {
            return new URI(cert);
        }
        return null;
    }

    public final void setCertificateName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.certificateNameSet) {
            throw new IllegalStateException("Certificate Name already set.");
        }
        this.getAddr().addExtension(CERTIFICATE_NAME_TAG, name);
        this.certificateNameSet = true;
    }

    public final String getCertificateName() {
        return this.getAddr().getExtensionValue(CERTIFICATE_NAME_TAG);
    }

    public EPR copy() {
        return new FTPSEpr(this);
    }

    public String toString() {
        return "FTPSEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public static URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/ftps");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

