/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortReference
implements Cloneable {
    private String _address = null;
    private LinkedList<Extension> _extensions = new LinkedList();
    private Extension _portType = null;
    private Extension _serviceName = null;
    private List _policies = null;

    public PortReference() {
    }

    public PortReference(String address) {
        this.setAddress(address);
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public String getAddress() {
        return this._address;
    }

    public void addExtension(Extension extension) {
        this._extensions.add(extension);
    }

    public void addExtension(String value) {
        this.addExtension("InstanceIdentifier", "jbossesb", "http://schemas.jboss.com/ws/2007/01/jbossesb", value, 0);
    }

    public void removeExtension(String tag, String value) {
        this._extensions.remove(new Extension(tag, "jbossesb", "http://schemas.jboss.com/ws/2007/01/jbossesb", value));
    }

    public void addExtension(String tag, String value) {
        this.addExtension(tag, "jbossesb", "http://schemas.jboss.com/ws/2007/01/jbossesb", value, 0);
    }

    public void addExtension(String tag, String prefix, String uri, String value) {
        this._extensions.add(new Extension(tag, prefix, uri, value, 0));
    }

    public void addExtension(String tag, String prefix, String uri, String value, int parent) {
        this._extensions.add(new Extension(tag, prefix, uri, value, parent));
    }

    public void addExtensions(List<Extension> extensions) {
        this._extensions.addAll(extensions);
    }

    public void addPortType(String qName) {
    }

    public void addServiceName(String portName, String qName) {
    }

    public void addPolicy() {
    }

    public String getExtensionValue(String tag) {
        String extensionValue = null;
        Iterator iterator = this._extensions.iterator();
        while (iterator.hasNext() && extensionValue == null) {
            Extension extension = (Extension)iterator.next();
            if (!tag.equals(extension.getTag())) continue;
            extensionValue = extension.getValue();
        }
        return extensionValue;
    }

    public Iterator<Extension> getExtensions() {
        return this._extensions.iterator();
    }

    public List<Extension> getAllExtensions() {
        return this._extensions;
    }

    public void clearExtensions() {
        this._extensions.clear();
    }

    public PortReference copy() {
        try {
            PortReference clone = (PortReference)this.clone();
            clone._extensions = new LinkedList<Extension>(this._extensions);
            return clone;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String toString() {
        return "PortReference < " + this._address + " >";
    }

    public String extendedToString() {
        StringBuilder addr = new StringBuilder("PortReference < ").append("<").append("wsa").append(":Address ").append(this._address + "/>");
        Iterator<Extension> extensions = this.getExtensions();
        while (extensions.hasNext()) {
            Extension ext = extensions.next();
            addr.append(", <").append("wsa").append(":").append("ReferenceProperties").append(" ").append(ext.getPrefix()).append(":").append(ext.getTag()).append(" : ").append(ext.getValue()).append("/>");
        }
        return addr.append(" >").toString();
    }

    public boolean equals(Object rhs) {
        if (rhs != null && rhs.getClass() == this.getClass()) {
            PortReference rhsPortReference = (PortReference)rhs;
            return PortReference.equalsObject(this._address, rhsPortReference._address) && PortReference.equalsObject(this._extensions, rhsPortReference._extensions) && PortReference.equalsObject(this._portType, rhsPortReference._portType) && PortReference.equalsObject(this._serviceName, rhsPortReference._serviceName) && PortReference.equalsObject(this._policies, rhsPortReference._policies);
        }
        return false;
    }

    public int hashCode() {
        return PortReference.objectHashCode(this._address, 1) ^ PortReference.objectHashCode(this._extensions, 2) ^ PortReference.objectHashCode(this._portType, 4) ^ PortReference.objectHashCode(this._serviceName, 8) ^ PortReference.objectHashCode(this._policies, 16);
    }

    static int objectHashCode(Object obj, int defaultHashCode) {
        return obj == null ? defaultHashCode : obj.hashCode();
    }

    static boolean equalsObject(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    public static class Extension {
        public static final int REFERENCE_PROPERTIES = 0;
        public static final int REFERENCE_PARAMETERS = 1;
        public static final int NEITHER = 2;
        private String _tag = null;
        private String _prefix = null;
        private String _uri = null;
        private String _value = null;
        private int _parent = 2;
        private LinkedList<Extension> _extensions = null;
        private HashMap _attributes = null;

        public Extension(String tag, String prefix, String uri) {
            this(tag, prefix, uri, null, 0);
        }

        public Extension(String tag, String prefix, String uri, String value) {
            this(tag, prefix, uri, value, 0);
        }

        public Extension(String tag, String prefix, String uri, String value, int parent) {
            this._tag = tag;
            this._prefix = prefix;
            this._uri = uri;
            this._value = value;
            this._parent = parent;
            if (this._uri == null) {
                this._uri = "http://schemas.jboss.com/ws/2007/01/jbossesb";
            }
            if (this._prefix == null) {
                this._prefix = "jbossesb";
            }
            if (this._tag.contains(":")) {
                int colon = this._tag.indexOf(58);
                this._tag = this._tag.substring(colon + 1);
            }
        }

        public int getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public String getURI() {
            return this._uri;
        }

        public String getValue() {
            return this._value;
        }

        public LinkedList getChildren() {
            return this._extensions;
        }

        public HashMap getAttributes() {
            return this._attributes;
        }

        public void addAttributes(HashMap props) {
            this._attributes = props;
        }

        public void addChild(Extension child) {
            if (this._extensions == null) {
                this._extensions = new LinkedList();
            }
            this._extensions.add(child);
        }

        public String toString() {
            return "< " + this._tag + ", " + this._prefix + ", " + this._uri + ", " + this._value + " >";
        }

        public boolean equals(Object rhs) {
            if (rhs != null && rhs.getClass() == this.getClass()) {
                Extension rhsExtension = (Extension)rhs;
                return PortReference.equalsObject(this._tag, rhsExtension._tag) && PortReference.equalsObject(this._uri, rhsExtension._uri) && PortReference.equalsObject(this._value, rhsExtension._value) && PortReference.equalsObject(this._extensions, rhsExtension._extensions) && this._parent == rhsExtension._parent;
            }
            return false;
        }

        public int hashCode() {
            return this._parent ^ PortReference.objectHashCode(this._tag, 4) ^ PortReference.objectHashCode(this._uri, 8) ^ PortReference.objectHashCode(this._value, 16) ^ PortReference.objectHashCode(this._extensions, 32);
        }
    }
}

