/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.validation.ValidationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SchemaValidationAction
extends AbstractActionPipelineProcessor {
    final Logger log = Logger.getLogger(SchemaValidationAction.class);
    private String xsd;
    private String schemaLanguage;
    private DocumentBuilderFactory docBuilderFactory;
    private Schema schema;
    private MessagePayloadProxy payloadProxy;

    public SchemaValidationAction(ConfigTree config) throws ConfigurationException {
        this.xsd = config.getRequiredAttribute("schema");
        this.schemaLanguage = config.getAttribute("schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.payloadProxy = new MessagePayloadProxy(config);
        this.docBuilderFactory = this.createDocumentBuilderFactory();
        this.schema = this.createSchema(this.xsd);
    }

    public Message process(Message message) throws ActionProcessingException {
        this.validate(this.extractXmlFromPayload(message));
        return message;
    }

    private void validate(String xml) throws ActionProcessingException {
        try {
            Validator validator = this.schema.newValidator();
            validator.validate(this.createDomSourceFromPayload(xml));
        }
        catch (SAXException e) {
            String errorMsg = "SAXException while trying to validate against schema '" + this.xsd + "'";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new ValidationException(errorMsg, e);
        }
        catch (IOException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
    }

    private String extractXmlFromPayload(Message message) throws ActionProcessingException {
        Object payload;
        try {
            payload = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        if (payload instanceof byte[]) {
            return new String((byte[])payload);
        }
        if (payload instanceof String) {
            return (String)payload;
        }
        throw new ActionProcessingException("Message payload must be either a byte[] or a String. The payload type was '" + payload.getClass().getName() + "'");
    }

    private DOMSource createDomSourceFromPayload(String xml) throws ActionProcessingException {
        try {
            DocumentBuilder parser = this.docBuilderFactory.newDocumentBuilder();
            Document document = parser.parse(new ByteArrayInputStream(xml.getBytes()));
            return new DOMSource(document);
        }
        catch (ParserConfigurationException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
    }

    private Schema createSchema(String xsd) throws ConfigurationException {
        SchemaFactory schemafactory = SchemaFactory.newInstance(this.schemaLanguage);
        try {
            return schemafactory.newSchema(new StreamSource(ClassUtil.getResourceAsStream(xsd, this.getClass())));
        }
        catch (SAXException e) {
            throw new ConfigurationException("Could not create a validator for schema '" + xsd + "'", e);
        }
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        return docBuilderFactory;
    }
}

