/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public final class ResultFactory {
    private static ResultFactory factory = new ResultFactory();

    private ResultFactory() {
    }

    public static ResultFactory getInstance() {
        return factory;
    }

    public Result createResult(ResultType type) {
        Result result = null;
        switch (type) {
            case STRING: {
                result = new StreamResult(new StringWriter());
                break;
            }
            case BYTES: {
                result = new StreamResult(new ByteArrayOutputStream());
                break;
            }
            case DOM: {
                result = new DOMResult();
                break;
            }
            case SAX: {
                result = new SAXResult();
                break;
            }
        }
        return result;
    }

    public Object extractResult(Result result, ResultType type) {
        switch (type) {
            case STRING: {
                return ((StreamResult)result).getWriter().toString();
            }
            case BYTES: {
                OutputStream outputStream = ((StreamResult)result).getOutputStream();
                return ((ByteArrayOutputStream)outputStream).toByteArray();
            }
            case DOM: {
                return ((DOMResult)result).getNode();
            }
            case SAX: {
                return (SAXResult)result;
            }
            case SOURCERESULT: {
                return result;
            }
        }
        throw new IllegalArgumentException("Result type not supported: " + result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        STRING,
        BYTES,
        DOM,
        SAX,
        SOURCERESULT;

    }
}

