/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.routing.AbstractRouter;
import org.jboss.soa.esb.actions.routing.http.HttpMethodFactory;
import org.jboss.soa.esb.actions.routing.http.ResponseType;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.jboss.soa.esb.http.HttpHeader;
import org.jboss.soa.esb.http.HttpRequest;
import org.jboss.soa.esb.http.HttpResponse;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.ResponseHeader;
import org.jboss.soa.esb.message.ResponseStatus;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.util.FileUtil;

public class HttpRouter
extends AbstractRouter {
    private static Logger logger = Logger.getLogger(HttpRouter.class);
    private ConfigTree config;
    private Properties httpClientProps = new Properties();
    private HttpClient httpclient;
    private URL endpointUrl;
    private String method;
    private HttpMethodFactory methodFactory;
    private ResponseType responseType;
    private String contentType;
    private ConfigTree[] requestHeaders;
    private boolean httpResponseStatusEnabled;
    private final String[] mappedHeaderList;
    private static Set<String> coreProperties = new HashSet<String>();

    public HttpRouter(ConfigTree config) throws ConfigurationException {
        super(config);
        this.config = config;
        try {
            this.endpointUrl = new URL(config.getRequiredAttribute("endpointUrl"));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid endpoint URL '" + config.getRequiredAttribute("endpointUrl") + "'.", e);
        }
        this.extractHttpClientProps(config);
        this.httpclient = HttpClientFactory.createHttpClient(this.httpClientProps);
        this.method = config.getRequiredAttribute("method");
        this.responseType = ResponseType.valueOf(config.getAttribute("responseType", ResponseType.STRING.toString()));
        this.methodFactory = HttpMethodFactory.Factory.getInstance(this.method.toUpperCase(), config, this.endpointUrl);
        this.contentType = config.getAttribute("Content-Type");
        this.mappedHeaderList = this.extractMappedHeaderListConfig();
        this.requestHeaders = config.getChildren("header");
        this.httpResponseStatusEnabled = ResponseStatus.isHttpEnabled(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message process(Message message) throws ActionProcessingException {
        HttpMethodBase method = null;
        try {
            method = this.methodFactory.getInstance(message);
            try {
                this.setRequestHeaders(method, message);
                int responseCode = this.httpclient.executeMethod((HttpMethod)method);
                if (responseCode != 200) {
                    logger.warn((Object)("Received status code '" + responseCode + "' on HTTP " + method + " request to '" + this.endpointUrl + "'."));
                }
                this.attachResponseDetails(message, method, responseCode);
                InputStream resultStream = method.getResponseBodyAsStream();
                try {
                    byte[] bytes = HttpRouter.readStream(resultStream);
                    if (this.responseType == ResponseType.STRING) {
                        this.getPayloadProxy().setPayload(message, new String(bytes, method.getResponseCharSet()));
                    } else {
                        this.getPayloadProxy().setPayload(message, bytes);
                    }
                }
                catch (MessageDeliverException e) {
                    throw new ActionProcessingException("problem setting message payload: " + e.getMessage(), e);
                }
                finally {
                    HttpRouter.closeStream(resultStream);
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (IOException e) {
            throw new ActionProcessingException("problem processing HTTP I/O: " + e.getMessage(), e);
        }
        return message;
    }

    static byte[] readStream(InputStream stream) throws IOException {
        if (stream != null) {
            return StreamUtils.readStream(stream);
        }
        return new byte[0];
    }

    static void closeStream(Closeable c) throws IOException {
        if (c != null) {
            c.close();
        }
    }

    private String[] extractMappedHeaderListConfig() throws ConfigurationException {
        String mappedHeaders = this.config.getAttribute("MappedHeaderList");
        if (mappedHeaders != null) {
            String[] headerList = mappedHeaders.split(",");
            int numHeaders = headerList.length;
            ArrayList<String> headers = new ArrayList<String>(numHeaders);
            for (int count = 0; count < numHeaders; ++count) {
                String header = headerList[count].trim();
                if (header.length() <= 0) continue;
                headers.add(header);
            }
            return headers.toArray(new String[headers.size()]);
        }
        return new String[0];
    }

    private void attachResponseDetails(Message message, HttpMethodBase method, int responseCode) {
        Header[] responseHeaders;
        HttpResponse response = new HttpResponse(responseCode);
        org.jboss.soa.esb.message.Properties properties = message.getProperties();
        response.setEncoding(method.getResponseCharSet());
        response.setLength(method.getResponseContentLength());
        for (Header responseHeader : responseHeaders = method.getResponseHeaders()) {
            String name = responseHeader.getName();
            String value = responseHeader.getValue();
            response.addHeader(new HttpHeader(name, value));
            new ResponseHeader(name, value).setPropertyNameThis(properties);
        }
        if (this.httpResponseStatusEnabled) {
            ResponseStatus.setHttpProperties(properties, responseCode, method.getStatusLine().getReasonPhrase());
        }
        response.setResponse(message);
    }

    private void setRequestHeaders(HttpMethodBase method, Message message) {
        this.setMappedHttpHeaders(method, message);
        for (int i = 0; i < this.requestHeaders.length; ++i) {
            ConfigTree header = this.requestHeaders[i];
            String name = header.getAttribute("name");
            String value = header.getAttribute("value");
            if (name != null && value != null) {
                method.setRequestHeader(name, value);
                continue;
            }
            logger.error((Object)("null Http request header name/value: '" + name + "':'" + value + "'."));
        }
        if (this.contentType != null) {
            method.setRequestHeader("Content-Type", this.contentType);
        } else if (method.getRequestHeader("Content-Type") == null) {
            method.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
        }
    }

    private void setMappedHttpHeaders(HttpMethodBase method, Message message) {
        HttpRequest request = HttpRequest.getRequest(message);
        org.jboss.soa.esb.message.Properties properties = message.getProperties();
        for (String headerName : this.mappedHeaderList) {
            String headerValue = null;
            if (request != null) {
                headerValue = this.getHttpHeaderValue(request, headerName);
            }
            if (headerValue == null) {
                headerValue = this.getHttpHeaderValue(properties, headerName);
            }
            if (headerValue == null) continue;
            method.setRequestHeader(headerName, headerValue);
        }
    }

    private String getHttpHeaderValue(HttpRequest request, String headerName) {
        String headerValue = null;
        for (HttpHeader header : request.getHeaders()) {
            String name = header.getName();
            if (!name.equalsIgnoreCase(headerName)) continue;
            headerValue = header.getValue();
            break;
        }
        return headerValue;
    }

    private String getHttpHeaderValue(org.jboss.soa.esb.message.Properties properties, String headerName) {
        String headerValue = null;
        for (String name : properties.getNames()) {
            if (!name.equalsIgnoreCase(headerName)) continue;
            Object property = properties.getProperty(name);
            if (property == null || (headerValue = property.toString()).length() != 0) break;
            headerValue = null;
            break;
        }
        return headerValue;
    }

    public String[] getMappedHeaderList() {
        return this.mappedHeaderList;
    }

    public void route(Object object) throws ActionProcessingException {
    }

    public void destroy() throws ActionLifecycleException {
        if (this.httpclient != null) {
            HttpClientFactory.shutdown(this.httpclient);
        }
        super.destroy();
    }

    private void extractHttpClientProps(ConfigTree config) {
        String maxThreads;
        ConfigTree[] httpClientConfigTrees = config.getChildren("http-client-property");
        this.httpClientProps.setProperty("target-host-url", this.endpointUrl.toString());
        ConfigTree parent = config.getParent();
        if (parent != null && (maxThreads = config.getParent().getAttribute("maxThreads")) != null) {
            this.httpClientProps.setProperty("max-total-connections", maxThreads);
        }
        for (ConfigTree httpClientProp : httpClientConfigTrees) {
            String propName = httpClientProp.getAttribute("name");
            String propValue = httpClientProp.getAttribute("value");
            if (propName == null || propValue == null) continue;
            this.httpClientProps.setProperty(propName, propValue);
        }
    }

    public static void main(String[] args) throws ConfigurationException, ActionProcessingException {
        ConfigTree configTree = new ConfigTree("config");
        for (String arg : args) {
            int equalsIdx = arg.indexOf(61);
            if (equalsIdx == -1) {
                throw new IllegalArgumentException("Arguments must be in 'name=value' format.");
            }
            String name = arg.substring(0, equalsIdx);
            String value = arg.substring(equalsIdx + 1);
            if (!coreProperties.contains(name) && !name.equals("payload")) {
                ConfigTree httpClientProperty = new ConfigTree("http-client-property", configTree);
                httpClientProperty.setAttribute("name", name);
                httpClientProperty.setAttribute("value", value);
                continue;
            }
            configTree.setAttribute(name, value);
        }
        HttpRouter router = new HttpRouter(configTree);
        Message message = MessageFactory.getInstance().getMessage();
        String payload = configTree.getAttribute("payload");
        if (payload != null) {
            try {
                File file = new File(payload);
                if (file.exists()) {
                    payload = FileUtil.readTextFile(file);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println("Request payload:\n" + payload);
            System.out.println("--------------------------\n");
            message.getBody().add(payload);
        }
        message = router.process(message);
        HttpResponse responseInfo = HttpResponse.getResponse(message);
        System.out.println();
        System.out.println("Response Status Code: " + responseInfo.getResponseCode());
        System.out.println("Response payload:\n" + message.getBody().get());
        System.out.println("--------------------------\n");
    }

    static {
        coreProperties.add("endpointUrl");
        coreProperties.add("method");
        coreProperties.add("responseType");
        coreProperties.add("Content-Type");
        coreProperties.add("method");
    }
}

