/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.http;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ClassUtil;

public interface HttpMethodFactory
extends Configurable {
    public void setEndpoint(URL var1);

    public HttpMethodBase getInstance(Message var1) throws IOException;

    public static class Factory {
        public static HttpMethodFactory getInstance(String method, ConfigTree config, URL endpointUrl) throws ConfigurationException {
            AssertArgument.isNotNullAndNotEmpty(method, "method");
            AssertArgument.isNotNull(config, "config");
            AssertArgument.isNotNull(endpointUrl, "endpointUrl");
            String className = HttpMethodFactory.class.getPackage().getName() + "." + method + HttpMethodFactory.class.getSimpleName();
            try {
                HttpMethodFactory factory = (HttpMethodFactory)ClassUtil.forName(className, HttpMethodFactory.class).newInstance();
                factory.setEndpoint(endpointUrl);
                factory.setConfiguration(config);
                return factory;
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Class '" + className + "' must implement '" + HttpMethodFactory.class.getName() + "'.");
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + className + "' not found on classpath.");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Class '" + className + "' cannot be instantiated.", e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + className + "' cannot be instantiated.", e);
            }
        }
    }
}

