/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public abstract class AbstractRouter
extends AbstractActionPipelineProcessor {
    public boolean unwrap = false;
    protected MessagePayloadProxy payloadProxy;

    public AbstractRouter(ConfigTree config) throws ConfigurationException {
        this.unwrap = config.getAttribute("unwrap", "false").equals("true");
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
    }

    public Message process(Message message) throws ActionProcessingException {
        if (this.unwrap) {
            Object content;
            try {
                content = this.payloadProxy.getPayload(message);
            }
            catch (MessageDeliverException e) {
                throw new ActionProcessingException(e);
            }
            this.route(content);
        } else {
            this.route(message);
        }
        return null;
    }

    public MessagePayloadProxy getPayloadProxy() {
        return this.payloadProxy;
    }

    public abstract void route(Object var1) throws ActionProcessingException;
}

