/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.naming.strategy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import org.jboss.soa.esb.actions.naming.strategy.AbstractFileNamingStrategy;
import org.jboss.soa.esb.actions.scripting.GroovyActionProcessor;
import org.jboss.soa.esb.message.Message;
import org.w3c.dom.Node;

public class GroovyNamingStrategy
extends AbstractFileNamingStrategy {
    private String scriptPath = "naming.groovy";
    public static final String DEFAULT_SCRIPT_PATH = "naming.groovy";
    public static final String ATTR_SCRIPT_PATH = "scriptPath";

    public void configure(Node xml) {
        Node scriptPathNode = xml.getAttributes().getNamedItem(ATTR_SCRIPT_PATH);
        if (scriptPathNode != null) {
            this.setScriptPath(scriptPathNode.getNodeValue());
        }
    }

    public String process(String filename, Message message) {
        try {
            String script = GroovyActionProcessor.getScriptFromClasspath(this.getScriptPath());
            Binding binding = new Binding();
            binding.setVariable("filename", (Object)filename);
            binding.setVariable("message", (Object)message);
            GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader(), binding);
            Object result = shell.evaluate(script);
            if (!(result instanceof String)) {
                throw new RuntimeException("Groovy script should return a String indicating processed filename");
            }
            return (String)result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }
}

