/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.naming;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.BeanConfiguredAction;
import org.jboss.soa.esb.actions.naming.strategy.FileNamingStrategy;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileNameGeneratorAction
extends AbstractActionPipelineProcessor
implements BeanConfiguredAction {
    private String fileNameProperty = "org.jboss.soa.esb.gateway.original.file.name";
    private String resultProperty = "org.jboss.soa.esb.naming.result";
    private String strategies;
    protected List<FileNamingStrategy> strategyImpls;
    public static final String DEFAULT_RESULT_PROPERTY = "org.jboss.soa.esb.naming.result";
    public static final String ELEMENT_STRATEGY = "strategy";
    public static final String ATTR_CLASS = "class";

    public Message process(Message message) throws ActionProcessingException {
        String currentFilename = (String)message.getProperties().getProperty(this.getFileNameProperty());
        for (FileNamingStrategy strategy : this.strategyImpls) {
            currentFilename = strategy.process(currentFilename, message);
        }
        message.getProperties().setProperty(this.getResultProperty(), currentFilename);
        return message;
    }

    protected void createStrategies() {
        this.strategyImpls = new ArrayList<FileNamingStrategy>();
        try {
            DOMParser parser = new DOMParser();
            InputSource source = new InputSource(new StringReader(this.getStrategies()));
            parser.parse(source);
            Document doc = parser.getDocument();
            NodeList strategyNodes = doc.getElementsByTagName(ELEMENT_STRATEGY);
            for (int i = 0; i < strategyNodes.getLength(); ++i) {
                FileNamingStrategy strategy = this.createStrategy(strategyNodes.item(i));
                this.strategyImpls.add(strategy);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected FileNamingStrategy createStrategy(Node strategyNode) {
        Node classNode = strategyNode.getAttributes().getNamedItem(ATTR_CLASS);
        if (classNode == null) {
            throw new RuntimeException("Strategy does not have 'class' attribute.");
        }
        try {
            Class strategyClass = ClassUtil.forName(classNode.getNodeValue(), this.getClass());
            FileNamingStrategy strategy = (FileNamingStrategy)strategyClass.newInstance();
            strategy.configure(strategyNode);
            return strategy;
        }
        catch (DOMException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setFileNameProperty(String fileNameProperty) {
        this.fileNameProperty = fileNameProperty;
    }

    public String getFileNameProperty() {
        return this.fileNameProperty;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public String getResultProperty() {
        return this.resultProperty;
    }

    public void setStrategies(String strategies) {
        this.strategies = strategies;
        this.createStrategies();
    }

    public String getStrategies() {
        return this.strategies;
    }
}

