/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.converters.xstream.conf.AttributeAliasConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.ClassAliasConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.ConverterConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.FieldAliasConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.ImplicitCollectionConf;
import org.jboss.soa.esb.helpers.ConfigTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamConfigurator {
    private final ConfigTree config;
    private List<ClassAliasConf> classAliases;
    private List<FieldAliasConf> fieldAliases;
    private List<AttributeAliasConf> attributeAliases;
    private List<ImplicitCollectionConf> implicitCollections;
    private List<ConverterConf> converters;

    public XStreamConfigurator(ConfigTree config) {
        AssertArgument.isNotNull(config, "config");
        this.config = config;
        this.classAliases = this.createClassAliases();
        this.fieldAliases = this.createFieldAliases();
        this.attributeAliases = this.createAttributeAliases();
        this.implicitCollections = this.createImplicitCollections();
        this.converters = this.createConverters();
    }

    public List<ClassAliasConf> getClassAliases() {
        return this.classAliases;
    }

    public List<FieldAliasConf> getFieldAliases() {
        return this.fieldAliases;
    }

    public List<AttributeAliasConf> getAttributeAliases() {
        return this.attributeAliases;
    }

    public List<ImplicitCollectionConf> getImplicitCollections() {
        return this.implicitCollections;
    }

    public List<ConverterConf> getConverters() {
        return this.converters;
    }

    private List<ClassAliasConf> createClassAliases() {
        ArrayList<ClassAliasConf> aliases = new ArrayList<ClassAliasConf>();
        ConfigTree[] children = this.config.getChildren("alias");
        if (children != null) {
            for (ConfigTree alias : children) {
                aliases.add(new ClassAliasConf(alias.getAttribute("name"), alias.getAttribute("class"), alias.getAttribute("defaultType")));
            }
        }
        return aliases;
    }

    private List<FieldAliasConf> createFieldAliases() {
        ArrayList<FieldAliasConf> aliases = new ArrayList<FieldAliasConf>();
        ConfigTree[] children = this.config.getChildren("field-alias");
        if (children != null) {
            for (ConfigTree alias : children) {
                aliases.add(new FieldAliasConf(alias.getAttribute("alias"), alias.getAttribute("definedIn"), alias.getAttribute("fieldName")));
            }
        }
        return aliases;
    }

    private List<AttributeAliasConf> createAttributeAliases() {
        ArrayList<AttributeAliasConf> aliases = new ArrayList<AttributeAliasConf>();
        ConfigTree[] children = this.config.getChildren("attribute-alias");
        if (children != null) {
            for (ConfigTree alias : children) {
                aliases.add(new AttributeAliasConf(alias.getAttribute("name"), alias.getAttribute("class")));
            }
        }
        return aliases;
    }

    private List<ImplicitCollectionConf> createImplicitCollections() {
        ArrayList<ImplicitCollectionConf> imps = new ArrayList<ImplicitCollectionConf>();
        ConfigTree[] children = this.config.getChildren("implicit-collection");
        if (children != null) {
            for (ConfigTree alias : children) {
                imps.add(new ImplicitCollectionConf(alias.getAttribute("ownerType"), alias.getAttribute("fieldName"), alias.getAttribute("itemFieldName"), alias.getAttribute("itemType")));
            }
        }
        return imps;
    }

    private List<ConverterConf> createConverters() {
        ArrayList<ConverterConf> converters = new ArrayList<ConverterConf>();
        ConfigTree[] children = this.config.getChildren("converter");
        if (children != null) {
            for (ConfigTree conv : children) {
                converters.add(new ConverterConf(conv.getAttribute("class"), conv.getAttribute("priority")));
            }
        }
        return converters;
    }

    public static void addClassAliases(List<ClassAliasConf> classAliases, XStream xstream) {
        for (ClassAliasConf classAlias : classAliases) {
            if (classAlias.getDefaultType() == null) {
                xstream.alias(classAlias.getAlias(), classAlias.getType());
                continue;
            }
            xstream.alias(classAlias.getAlias(), classAlias.getType(), classAlias.getDefaultType());
        }
    }

    public static void addFieldAliases(List<FieldAliasConf> fieldAliases, XStream xstream) throws ActionProcessingException {
        if (fieldAliases == null) {
            return;
        }
        for (FieldAliasConf fieldAlias : fieldAliases) {
            xstream.aliasField(fieldAlias.getAlias(), fieldAlias.getDefinedIn(), fieldAlias.getFieldName());
        }
    }

    public static void addImplicitCollections(List<ImplicitCollectionConf> implicitCollections, XStream xstream) throws ActionProcessingException {
        if (implicitCollections == null) {
            return;
        }
        for (ImplicitCollectionConf impl : implicitCollections) {
            if (impl.getItemFieldName() != null && impl.getItemType() != null) {
                xstream.addImplicitCollection(impl.getOwnerType(), impl.getFieldName(), impl.getItemFieldName(), impl.getItemType());
                continue;
            }
            if (impl.getItemType() != null) {
                xstream.addImplicitCollection(impl.getOwnerType(), impl.getFieldName(), impl.getItemType());
                continue;
            }
            xstream.addImplicitCollection(impl.getOwnerType(), impl.getFieldName());
        }
    }

    public static void addConverters(List<ConverterConf> converters, XStream xstream) throws ActionProcessingException {
        if (converters == null) {
            return;
        }
        for (ConverterConf conf : converters) {
            if (conf.getPriority() == -1) {
                xstream.registerConverter(conf.getConverter());
                continue;
            }
            xstream.registerConverter(conf.getConverter(), conf.getPriority());
        }
    }
}

