/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.cbr;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.cbr.AbstractPropertyRulesRouter;
import org.jboss.soa.esb.actions.cbr.RoutingRule;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.util.XPathNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathRouter
extends AbstractPropertyRulesRouter {
    private XPathNamespaceContext namespaceContext;

    @Override
    public void setConfigTree(ConfigTree configTree) throws MessageRouterException {
        try {
            this.namespaceContext = new NamespaceContext(configTree.getChildren("namespace"));
        }
        catch (ConfigurationException e) {
            throw new MessageRouterException("Error loading namespace prefix mappings.", e);
        }
        super.setConfigTree(configTree);
    }

    @Override
    public Map<String, RoutingRule> buildRoutingMap(Properties rules) throws MessageRouterException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        HashMap<String, RoutingRule> routingMap = new HashMap<String, RoutingRule>();
        xpath.setNamespaceContext(this.namespaceContext);
        Set<Map.Entry<Object, Object>> ruleSet = rules.entrySet();
        for (Map.Entry<Object, Object> rule : ruleSet) {
            String destinationName = (String)rule.getKey();
            String expression = (String)rule.getValue();
            try {
                routingMap.put(destinationName, new XPathRoutingRule(xpath.compile(expression)));
            }
            catch (XPathExpressionException e) {
                throw new MessageRouterException("Error compiling XPath expression '" + expression + "'.", e);
            }
        }
        return routingMap;
    }

    public javax.xml.namespace.NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    private static class NamespaceContext
    extends XPathNamespaceContext {
        public NamespaceContext(ConfigTree[] namespaces) throws ConfigurationException {
            if (namespaces != null) {
                for (ConfigTree namespace : namespaces) {
                    String prefix = namespace.getRequiredAttribute("prefix");
                    String uri = namespace.getRequiredAttribute("uri");
                    this.setMapping(prefix, uri);
                }
            }
        }
    }

    private class XPathRoutingRule
    implements RoutingRule {
        private XPathExpression xpathExpression;

        private XPathRoutingRule(XPathExpression xpathExpression) {
            this.xpathExpression = xpathExpression;
        }

        public boolean evaluate(Object objectToTest) throws MessageRouterException {
            try {
                if (objectToTest instanceof String) {
                    return (Boolean)this.xpathExpression.evaluate(new InputSource(new StringReader((String)objectToTest)), XPathConstants.BOOLEAN);
                }
                if (objectToTest instanceof byte[]) {
                    return (Boolean)this.xpathExpression.evaluate(new InputSource(new ByteArrayInputStream((byte[])objectToTest)), XPathConstants.BOOLEAN);
                }
                if (objectToTest instanceof Node || objectToTest instanceof NodeList) {
                    return (Boolean)this.xpathExpression.evaluate(objectToTest, XPathConstants.BOOLEAN);
                }
                XPathRouter.this.logger.debug((Object)("Unsupported XPath evaluation type '" + objectToTest.getClass().getName() + "'."));
            }
            catch (XPathExpressionException e) {
                XPathRouter.this.logger.debug((Object)"Error evaluating xpath expression.", (Throwable)e);
            }
            return false;
        }
    }
}

