/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.TestMessageStoreSink;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class TestMessageStore
extends AbstractActionPipelineProcessor {
    public static final String LOCATION = "location";
    public static final String LOG_SUCCESS = "logSuccess";
    public static final String LOG_EXCEPTION = "logException";
    private static TestMessageStoreSink testMessageStoreSink;
    private final MessagePayloadProxy payloadProxy;
    private final boolean logSuccess;
    private final boolean logException;

    public TestMessageStore(ConfigTree config) {
        String location = config.getAttribute(LOCATION);
        if (location != null) {
            config.setAttribute("get-payload-location", location);
        }
        this.payloadProxy = new MessagePayloadProxy(config);
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
        this.logSuccess = config.getBooleanAttribute(LOG_SUCCESS, false);
        this.logException = config.getBooleanAttribute(LOG_EXCEPTION, false);
    }

    public Message process(Message message) throws ActionProcessingException {
        TestMessageStore.logContents(this.getContents(message));
        return message;
    }

    public void processException(Message message, Throwable th) {
        if (this.logException) {
            try {
                TestMessageStore.logContents(th.getLocalizedMessage() + ':' + this.getContents(message));
            }
            catch (ActionProcessingException ape) {
                TestMessageStore.logContents(ape.getLocalizedMessage());
            }
        }
    }

    public void processSuccess(Message message) {
        if (this.logSuccess) {
            try {
                TestMessageStore.logContents("Success:" + this.getContents(message));
            }
            catch (ActionProcessingException ape) {
                TestMessageStore.logContents(ape.getLocalizedMessage());
            }
        }
    }

    private String getContents(Message message) throws ActionProcessingException {
        Object contents;
        try {
            contents = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException mde) {
            throw new ActionProcessingException(mde);
        }
        if (contents != null) {
            String messageVal = contents instanceof byte[] ? new String((byte[])contents) : contents.toString();
            return messageVal;
        }
        return null;
    }

    public static synchronized void setMessageStoreSink(TestMessageStoreSink testMessageStoreSink) {
        TestMessageStore.testMessageStoreSink = testMessageStoreSink;
    }

    private static synchronized void logContents(String message) {
        if (testMessageStoreSink != null) {
            testMessageStoreSink.logMessage(message);
        }
    }
}

