/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.cbr.RegexRouter;
import org.jboss.soa.esb.actions.cbr.XPathRouter;
import org.jboss.soa.esb.client.MessageMulticaster;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.mapping.ObjectMapper;
import org.jboss.soa.esb.message.mapping.ObjectMappingException;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryFactory;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.services.routing.cbr.ContentBasedRouter;
import org.jboss.soa.esb.services.routing.cbr.ContentBasedRouterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentBasedWiretap
extends AbstractActionPipelineProcessor {
    public static final String ROUTE_TO_TAG = "route-to";
    public static final String OBJECT_PATH_TAG = "object-path";
    public static final String OBJECT_PATH = "esb";
    public static final String ENTRY_POINT = "entry-point";
    public static final String DEFAULT_CBR_CLASS = "org.jboss.internal.soa.esb.services.routing.cbr.JBossRulesRouter";
    ServiceInvoker dlQueueInvoker;
    protected ConfigTree _config;
    protected Map<String, Service> _destinations;
    protected MessageMulticaster messageMulticaster = new MessageMulticaster();
    protected String _cbrClass;
    protected String _ruleSet;
    protected String _ruleLanguage;
    protected boolean _ruleReload;
    protected List<String> _messagePathList;
    protected Map<String, List<String>> entryPointMap;
    protected ObjectMapper _mapper;
    protected Registry _registry;
    protected ContentBasedRouter _cbr;
    protected static final Logger _logger = Logger.getLogger(ContentBasedWiretap.class);

    public ContentBasedWiretap(ConfigTree config) throws ConfigurationException, RegistryException, MessageRouterException {
        this._config = config;
        this.checkMyParms();
        this._registry = RegistryFactory.getRegistry();
        this._cbr = ContentBasedRouterFactory.getRouter(this._cbrClass);
        this._cbr.setConfigTree(config);
        this._mapper = new ObjectMapper(config);
        try {
            this.dlQueueInvoker = new ServiceInvoker("JBossESB-Internal", "DeadLetterService");
        }
        catch (MessageDeliverException e) {
            throw new MessageRouterException(e);
        }
    }

    @Override
    public void initialise() {
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        try {
            List<Service> outgoingDestinations = this.executeRules(message);
            if (outgoingDestinations.size() == 0) {
                String error = "No rule destination(s) " + this._destinations.keySet() + " were matched, " + ". Please fix your configuration and/or routing rules.";
                _logger.error((Object)error);
                try {
                    _logger.debug((Object)"Sending message to the DeadLetterService");
                    this.dlQueueInvoker.deliverAsync(message);
                    throw new ActionProcessingException(error);
                }
                catch (MessageDeliverException e) {
                    throw new MessageRouterException("Failed to deliver message to Dead Letter Channel.", e);
                }
            }
            this.routeMessage(message, outgoingDestinations);
        }
        catch (MessageRouterException e) {
            throw new ActionProcessingException(e);
        }
        return message;
    }

    protected List<Service> executeRules(Message message) throws MessageRouterException {
        ArrayList<Service> outgoingDestinations = new ArrayList<Service>();
        try {
            List<Object> objectList = this._mapper.createObjectList(message, this._messagePathList);
            List<String> destinations = this._cbr.route(this._ruleSet, this._ruleLanguage, this._ruleReload, message, objectList);
            for (String destination : destinations) {
                if (this._destinations.containsKey(destination)) {
                    outgoingDestinations.add(this._destinations.get(destination));
                    continue;
                }
                throw new MessageRouterException("Destination " + destination + " does not exist your configuration");
            }
        }
        catch (ObjectMappingException ome) {
            throw new MessageRouterException(ome);
        }
        return outgoingDestinations;
    }

    protected final void routeMessage(Message message, List<Service> outgoingDestinations) throws MessageRouterException {
        try {
            this.messageMulticaster.sendToSubset(message, outgoingDestinations);
        }
        catch (RegistryException e) {
            throw new MessageRouterException(e);
        }
        catch (MessageDeliverException e) {
            throw new MessageRouterException(e);
        }
    }

    protected void checkMyParms() throws ConfigurationException {
        this._ruleSet = this._config.getAttribute("ruleSet");
        this._ruleLanguage = this._config.getAttribute("ruleLanguage");
        String ruleReload = this._config.getAttribute("ruleReload");
        if (ruleReload != null && "true".equals(ruleReload)) {
            this._ruleReload = true;
        }
        String cbrAlias = this._config.getAttribute("cbrAlias");
        this._cbrClass = this._config.getAttribute("cbrClass");
        if (cbrAlias != null && this._cbrClass != null) {
            throw new ConfigurationException("Invalid " + this.getClass().getSimpleName() + " configuration.  Cannot configure both '" + "cbrAlias" + "' and '" + "cbrClass" + "' properties on the same action configuration.");
        }
        if (this._cbrClass == null) {
            if (cbrAlias == null) {
                this._cbrClass = DEFAULT_CBR_CLASS;
            } else if (cbrAlias.equalsIgnoreCase("JBRules") || cbrAlias.equalsIgnoreCase("Drools")) {
                this._cbrClass = DEFAULT_CBR_CLASS;
            } else if (cbrAlias.equalsIgnoreCase("XPath")) {
                this._cbrClass = XPathRouter.class.getName();
            } else if (cbrAlias.equalsIgnoreCase("Regex") || cbrAlias.equalsIgnoreCase("Regexp")) {
                this._cbrClass = RegexRouter.class.getName();
            } else {
                throw new ConfigurationException("Invalid " + this.getClass().getSimpleName() + " configuration.  Unsupported '" + "cbrAlias" + "' property value '" + cbrAlias + "'.");
            }
        }
        this._destinations = new HashMap<String, Service>();
        ConfigTree[] destList = this._config.getChildren(ROUTE_TO_TAG);
        if (destList != null) {
            for (ConfigTree curr : destList) {
                try {
                    String key = ContentBasedWiretap.buildDestinationKey(curr);
                    String category = curr.getAttribute("service-category", "");
                    String name = curr.getRequiredAttribute("service-name");
                    Service service = new Service(category, name);
                    this._destinations.put(key, service);
                    this.messageMulticaster.addRecipient(service);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Problems with destination list", e);
                }
            }
        }
        this._messagePathList = new ArrayList<String>();
        this.entryPointMap = new HashMap<String, List<String>>();
        ConfigTree[] objectList = this._config.getChildren(OBJECT_PATH_TAG);
        if (objectList != null) {
            for (ConfigTree curr : objectList) {
                try {
                    String objectPath = curr.getRequiredAttribute(OBJECT_PATH);
                    String entryPoint = curr.getAttribute(ENTRY_POINT);
                    if (entryPoint != null) {
                        List<String> list = this.entryPointMap.get(entryPoint);
                        if (list == null) {
                            list = new ArrayList<String>();
                            this.entryPointMap.put(entryPoint, list);
                        }
                        list.add(objectPath);
                        continue;
                    }
                    this._messagePathList.add(objectPath);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Problems with object path list", e);
                }
            }
        }
    }

    public static String buildDestinationKey(ConfigTree destinationConfig) throws ConfigurationException {
        String key = destinationConfig.getAttribute("destination-name");
        if (key != null) {
            return key;
        }
        String category = destinationConfig.getAttribute("service-category", "");
        String name = destinationConfig.getRequiredAttribute("service-name");
        return category + "-" + name;
    }
}

