/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util.stax;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.QNameHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamHelper {
    private static final String UNBOUND_NAMESPACE = "http://www.jboss.com/stax/parsing/unboundnamespace";

    public static String writeStartElement(XMLStreamWriter out, QName elementName) throws XMLStreamException {
        boolean writeNamespace;
        String namespaceURI = QNameHelper.getNormalisedValue(elementName.getNamespaceURI());
        String localName = elementName.getLocalPart();
        NamespaceContext namespaceContext = out.getNamespaceContext();
        boolean bl = writeNamespace = namespaceContext.getPrefix(namespaceURI) == null;
        if (writeNamespace) {
            String prefix = QNameHelper.getNormalisedValue(elementName.getPrefix());
            String origNamespace = QNameHelper.getNormalisedValue(namespaceContext.getNamespaceURI(prefix));
            if (prefix.length() == 0) {
                out.setDefaultNamespace(namespaceURI);
                out.writeStartElement(namespaceURI, localName);
                out.writeDefaultNamespace(namespaceURI);
            } else {
                out.setPrefix(prefix, namespaceURI);
                out.writeStartElement(namespaceURI, localName);
                out.writeNamespace(prefix, namespaceURI);
            }
            return origNamespace;
        }
        out.writeStartElement(namespaceURI, localName);
        return null;
    }

    public static void writeEndElement(XMLStreamWriter out, String prefix, String namespaceURI) throws XMLStreamException {
        out.writeEndElement();
        if (namespaceURI != null) {
            String resetNamespace;
            String string = resetNamespace = namespaceURI.length() == 0 ? UNBOUND_NAMESPACE : namespaceURI;
            if (prefix.length() == 0) {
                out.setDefaultNamespace(resetNamespace);
            } else {
                out.setPrefix(prefix, resetNamespace);
            }
        }
    }

    public static void writeElement(XMLStreamWriter out, QName elementName, ElementContent elementContent) throws XMLStreamException {
        String origNamespace = StreamHelper.writeStartElement(out, elementName);
        elementContent.writeContent(out);
        StreamHelper.writeEndElement(out, elementName.getPrefix(), origNamespace);
    }

    public static void writeAttributes(XMLStreamWriter out, Map<QName, Object> attributes) throws XMLStreamException {
        Set<Map.Entry<QName, Object>> entrySet = attributes.entrySet();
        for (Map.Entry<QName, Object> entry : entrySet) {
            QName name = entry.getKey();
            Object value = entry.getValue();
            StreamHelper.writeAttribute(out, name, value);
        }
    }

    public static void writeAttribute(XMLStreamWriter out, QName attributeName, Object attributeValue) throws XMLStreamException {
        if (attributeValue instanceof QName) {
            StreamHelper.writeAttribute(out, attributeName, (QName)attributeValue);
        } else {
            StreamHelper.writeAttribute(out, attributeName, attributeValue.toString());
        }
    }

    public static void writeAttribute(XMLStreamWriter out, QName attributeName, QName attributeValue) throws XMLStreamException {
        String namespaceURI = QNameHelper.getNormalisedValue(attributeValue.getNamespaceURI());
        if (namespaceURI.length() == 0) {
            StreamHelper.writeAttribute(out, attributeName, attributeValue.getLocalPart());
        } else {
            NamespaceContext namespaceContext = out.getNamespaceContext();
            String origPrefix = namespaceContext.getPrefix(namespaceURI);
            if (origPrefix == null) {
                String prefix = QNameHelper.getNormalisedValue(attributeValue.getPrefix());
                StreamHelper.writeNamespace(out, prefix, namespaceURI);
                StreamHelper.writeAttribute(out, attributeName, QNameHelper.toQualifiedName(attributeValue));
            } else {
                StreamHelper.writeAttribute(out, attributeName, QNameHelper.toQualifiedName(origPrefix, attributeValue.getLocalPart()));
            }
        }
    }

    public static void writeAttribute(XMLStreamWriter out, QName attributeName, String attributeValue) throws XMLStreamException {
        String namespaceURI = QNameHelper.getNormalisedValue(attributeName.getNamespaceURI());
        String localName = attributeName.getLocalPart();
        if (namespaceURI.length() == 0) {
            out.writeAttribute(localName, attributeValue);
        } else {
            String prefix = QNameHelper.getNormalisedValue(attributeName.getPrefix());
            StreamHelper.writeNamespace(out, prefix, namespaceURI);
            out.writeAttribute(namespaceURI, localName, attributeValue);
        }
    }

    public static void writeQualifiedName(XMLStreamWriter out, QName qName) throws XMLStreamException {
        String namespaceURI = QNameHelper.getNormalisedValue(qName.getNamespaceURI());
        if (namespaceURI.length() == 0) {
            out.writeCharacters(QNameHelper.toQualifiedName(qName));
        } else {
            NamespaceContext namespaceContext = out.getNamespaceContext();
            String origPrefix = namespaceContext.getPrefix(namespaceURI);
            if (origPrefix == null) {
                String prefix = QNameHelper.getNormalisedValue(qName.getPrefix());
                StreamHelper.writeNamespace(out, prefix, namespaceURI);
                out.writeCharacters(QNameHelper.toQualifiedName(qName));
            } else {
                out.writeCharacters(QNameHelper.toQualifiedName(origPrefix, qName.getLocalPart()));
            }
        }
    }

    public static void writeNamespace(XMLStreamWriter out, String prefix, String namespaceURI) throws XMLStreamException {
        boolean writeNamespace;
        NamespaceContext namespaceContext = out.getNamespaceContext();
        boolean bl = writeNamespace = namespaceContext.getPrefix(namespaceURI) == null;
        if (writeNamespace) {
            out.setPrefix(prefix, namespaceURI);
            out.writeNamespace(prefix, namespaceURI);
        }
    }

    public static void skipToNextStartElement(XMLStreamReader streamReader) throws XMLStreamException {
        if (streamReader.hasNext()) {
            streamReader.nextTag();
            if (streamReader.isEndElement()) {
                throw new XMLStreamException("Unexpected end element: " + streamReader.getName());
            }
        } else {
            throw new XMLStreamException("Unexpected end of document reached");
        }
    }

    public static void skipToStartElement(XMLStreamReader streamReader) throws XMLStreamException {
        while (!streamReader.isStartElement()) {
            if (streamReader.hasNext()) {
                streamReader.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end of document reached");
        }
    }

    public static void checkNextStartTag(XMLStreamReader streamReader, QName expected) throws XMLStreamException {
        StreamHelper.skipToNextStartElement(streamReader);
        StreamHelper.checkTag(streamReader, expected);
    }

    public static void checkEndTag(XMLStreamReader streamReader, QName expected) throws XMLStreamException {
        streamReader.require(2, expected.getNamespaceURI(), expected.getLocalPart());
    }

    public static void checkTag(XMLStreamReader streamReader, QName expected) throws XMLStreamException {
        QName elementName = streamReader.getName();
        if (!expected.equals(elementName)) {
            throw new XMLStreamException("Unexpected start element: " + elementName);
        }
    }

    public static boolean checkParentFinished(XMLStreamReader streamReader) throws XMLStreamException {
        return streamReader.nextTag() == 2;
    }

    public static String getAttributeValue(XMLStreamReader streamReader, QName name) {
        return streamReader.getAttributeValue(name.getNamespaceURI(), name.getLocalPart());
    }
}

