/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;

public abstract class ParsingSupport {
    public boolean isValid() {
        return true;
    }

    protected final void parse(XMLStreamReader in) throws XMLStreamException {
        int attributeCount = in.getAttributeCount();
        for (int count = 0; count < attributeCount; ++count) {
            QName attributeName = in.getAttributeName(count);
            String attributeValue = in.getAttributeValue(count);
            this.putAttribute(in, attributeName, attributeValue);
        }
        QName name = in.getName();
        boolean finished = false;
        do {
            int type = in.next();
            switch (type) {
                case 1: {
                    QName startElementName = in.getName();
                    this.putElement(in, startElementName);
                    StreamHelper.checkEndTag(in, startElementName);
                    break;
                }
                case 2: {
                    StreamHelper.checkEndTag(in, name);
                    finished = true;
                    break;
                }
                case 4: 
                case 12: {
                    this.putValue(in, in.getText());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 11: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    throw new XMLStreamException("Encountered unexpected event type: " + type);
                }
            }
        } while (!finished);
    }

    protected void putValue(XMLStreamReader in, String value) throws XMLStreamException {
    }

    protected void putAttribute(XMLStreamReader in, QName attributeName, String attributeValue) throws XMLStreamException {
    }

    protected abstract void putElement(XMLStreamReader var1, QName var2) throws XMLStreamException;
}

