/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.IdentitySAXHandler;
import org.jboss.internal.soa.esb.util.SchemaResolver;
import org.jboss.internal.soa.esb.util.stax.ParsingSupport;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHelper {
    private static Logger log = Logger.getLogger(XMLHelper.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLHelper.getXMLInputFactory();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();

    public static XMLStreamReader getXMLStreamReader(Reader reader) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(reader);
    }

    public static XMLStreamReader getXMLStreamReader(InputStream is) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(is);
    }

    public static XMLStreamReader getXMLStreamReader(InputStream is, String encoding) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(is, encoding);
    }

    public static XMLStreamWriter getXMLStreamWriter(Writer writer) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream os) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(os);
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream os, String encoding) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(os, encoding);
    }

    public static void replaceSystemProperties(XMLStreamReader streamReader, XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartDocument();
        StreamHelper.skipToStartElement(streamReader);
        QName elementName = streamReader.getName();
        String uri = StreamHelper.writeStartElement(streamWriter, elementName);
        new SystemPropertyReplacementParser(streamReader, streamWriter);
        StreamHelper.writeEndElement(streamWriter, elementName.getPrefix(), uri);
        streamWriter.writeEndDocument();
        streamWriter.flush();
    }

    public static Schema getSchema(String resource) throws SAXException {
        try {
            URI schemaUri = XMLHelper.getResourceUri(resource, XMLHelper.class);
            log.debug((Object)("schemaUri : " + schemaUri));
            SchemaResolver schemaResolver = new SchemaResolver(schemaUri);
            URL schemaUrl = schemaUri.getScheme().equals("classpath") ? ClassUtil.getResource(schemaUri.getPath(), XMLHelper.class) : schemaUri.toURL();
            log.debug((Object)("schemaUrl : " + schemaUrl));
            return XMLHelper.getSchema(schemaUrl, schemaResolver);
        }
        catch (URISyntaxException e) {
            throw new SAXException("URISyntaxException while trying to locate '" + resource + "'");
        }
        catch (MalformedURLException e) {
            throw new SAXException("MalformedURLException while trying to located '" + resource + "'");
        }
        catch (IOException e) {
            throw new SAXException("IOException while trying to locate '" + resource + "'");
        }
    }

    public static Schema getSchema(URL resource, LSResourceResolver resolver) throws SAXException, IOException {
        SchemaFactory schemaFactory = XMLHelper.newSchemaFactory();
        schemaFactory.setResourceResolver(resolver);
        InputStream resourceIS = resource.openStream();
        return schemaFactory.newSchema(new StreamSource(resourceIS));
    }

    public static URI getResourceUri(String resourceName, Class<?> caller) throws URISyntaxException, MalformedURLException {
        URL url;
        URL url2;
        ClassLoader threadClassLoader;
        File file = new File(resourceName);
        if (file.exists() && !file.isDirectory()) {
            return file.toURI();
        }
        String resource = resourceName;
        if (resourceName.startsWith("/")) {
            resource = resourceName.substring(1);
        }
        if ((threadClassLoader = Thread.currentThread().getContextClassLoader()) != null && (url2 = threadClassLoader.getResource(resource)) != null) {
            return URI.create("classpath://" + resourceName);
        }
        ClassLoader classLoader = caller.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return URI.create("classpath://" + resourceName);
        }
        URL systemResource = ClassLoader.getSystemResource(resource);
        if (systemResource != null) {
            return systemResource.toURI();
        }
        return new URI(resourceName);
    }

    public static Schema getSchema(String[] resources) throws SAXException {
        int numResources = resources == null ? 0 : resources.length;
        Source[] sources = new Source[numResources];
        for (int count = 0; count < numResources; ++count) {
            InputStream resourceIS = ClassUtil.getResourceAsStream(resources[count], XMLHelper.class);
            sources[count] = new StreamSource(resourceIS);
        }
        return XMLHelper.newSchemaFactory().newSchema(sources);
    }

    public static boolean validate(Schema schema, String xml) {
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xml)));
            return true;
        }
        catch (IOException ioe) {
            log.debug((Object)ioe.getMessage(), (Throwable)ioe);
        }
        catch (SAXException saxe) {
            log.debug((Object)saxe.getMessage(), (Throwable)saxe);
        }
        return false;
    }

    public static boolean compareXMLContent(InputStream content1, InputStream content2) throws ParserConfigurationException, SAXException, IOException {
        return XMLHelper.compareXMLContent(new InputSource(content1), new InputSource(content2));
    }

    public static boolean compareXMLContent(String content1, String content2) throws ParserConfigurationException, SAXException, IOException {
        return XMLHelper.compareXMLContent(new StringReader(content1), new StringReader(content2));
    }

    public static boolean compareXMLContent(Reader content1, Reader content2) throws ParserConfigurationException, SAXException, IOException {
        return XMLHelper.compareXMLContent(new InputSource(content1), new InputSource(content2));
    }

    public static boolean compareXMLContent(InputSource content1, InputSource content2) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        IdentitySAXHandler handler1 = new IdentitySAXHandler();
        parser.parse(content1, (DefaultHandler)handler1);
        IdentitySAXHandler handler2 = new IdentitySAXHandler();
        parser.parse(content2, (DefaultHandler)handler2);
        return handler1.getRootElement().equals(handler2.getRootElement());
    }

    private static SchemaFactory newSchemaFactory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlInputFactory;
    }

    private static final class SystemPropertyReplacementParser
    extends ParsingSupport {
        private final XMLStreamWriter out;

        SystemPropertyReplacementParser(XMLStreamReader in, XMLStreamWriter out) throws XMLStreamException {
            this.out = out;
            this.parse(in);
        }

        protected void putValue(XMLStreamReader in, String value) throws XMLStreamException {
            this.out.writeCharacters(StringPropertyReplacer.replaceProperties((String)value));
        }

        protected void putAttribute(XMLStreamReader in, QName attributeName, String attributeValue) throws XMLStreamException {
            StreamHelper.writeAttribute(this.out, attributeName, StringPropertyReplacer.replaceProperties((String)attributeValue));
        }

        protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
            String uri = StreamHelper.writeStartElement(this.out, elementName);
            new SystemPropertyReplacementParser(in, this.out);
            StreamHelper.writeEndElement(this.out, elementName.getPrefix(), uri);
        }
    }
}

