/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.jboss.deployment.DeploymentException;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.webservice.AddressingHandler;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;
import org.jboss.soa.esb.listeners.config.model.ModelParser;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDeployerUtil {
    private static final String PREFIX_CANONICAL_NAME = "jboss.esb:deployment=";
    private static final String ESB_ARTIFACT_NAME = "jbossesb.esb";
    private static final String HANDLER_CHAIN_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><handler-chains xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee javaee_web_services_1_2.xsd\"><handler-chain><protocol-bindings>##SOAP11_HTTP</protocol-bindings>";
    private static final String HANDLER_CHAIN_POSTFIX = "</handler-chain></handler-chains>";
    private static final String HANDLER_PREFIX = "<handler><handler-name>";
    private static final String HANDLER_MIDDLE = "</handler-name><handler-class>";
    private static final String HANDLER_POSTFIX = "</handler-class></handler>";
    private static final String WSADDR_NAME = "WSAddressing Handler";
    private static final String WSADDR_HANDLER = "org.jboss.ws.extensions.addressing.jaxws.WSAddressingServerHandler";
    private static final String WSADDR_CONTEXT_NAME = "WSAddressing Context Handler";
    private static final String WSADDR_CONTEXT_HANDLER = AddressingHandler.class.getName();
    private static Logger log = Logger.getLogger(JBossDeployerUtil.class);

    private JBossDeployerUtil() {
    }

    public static String getHandlers(ESBServiceEndpointInfo serviceInfo) {
        String result;
        if (!serviceInfo.isAddressing()) {
            result = null;
        } else {
            StringBuilder sb = new StringBuilder(HANDLER_CHAIN_PREFIX);
            if (serviceInfo.isAddressing()) {
                sb.append(HANDLER_PREFIX).append(WSADDR_CONTEXT_NAME).append(HANDLER_MIDDLE).append(WSADDR_CONTEXT_HANDLER).append(HANDLER_POSTFIX);
                sb.append(HANDLER_PREFIX).append(WSADDR_NAME).append(HANDLER_MIDDLE).append(WSADDR_HANDLER).append(HANDLER_POSTFIX);
            }
            sb.append(HANDLER_CHAIN_POSTFIX);
            result = sb.toString();
        }
        return result;
    }

    public static File getESBWarFile(String deploymentName, String esbName, boolean createDir, File dir) {
        File esbDir = new File(dir, deploymentName);
        if (!esbDir.exists()) {
            if (!createDir) {
                return null;
            }
            esbDir.mkdir();
        }
        int lastSeparator = esbName.lastIndexOf(46);
        String warFileName = (lastSeparator >= 0 ? esbName.substring(0, lastSeparator) : esbName) + ".war";
        return new File(esbDir, warFileName);
    }

    public static File createDir(File parentDir, String dirName) {
        File esbWarFiles = new File(parentDir, dirName);
        esbWarFiles.mkdirs();
        return esbWarFiles;
    }

    public static String readEsbConfig(InputStream in) throws DeploymentException {
        try {
            StringWriter sw = new StringWriter();
            XMLHelper.replaceSystemProperties(XMLHelper.getXMLStreamReader(in), XMLHelper.getXMLStreamWriter(sw));
            String string = sw.toString();
            return string;
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }

    public static ModelAdapter getJbossEsbModel(String configuration) throws DeploymentException {
        try {
            StringReader sr = new StringReader(configuration);
            return ModelParser.getParser().parse(sr);
        }
        catch (Exception ex) {
            throw new DeploymentException("Failed to parse jboss-esb.xml", (Throwable)ex);
        }
    }

    public static Properties getArtifactProperties(String fileName) throws IOException {
        Properties properties = null;
        InputStream in = ClassUtil.getResourceAsStream(fileName, JBossDeployerUtil.class);
        if (in != null) {
            log.debug((Object)("Loaded action artifact mapping from " + fileName));
            properties = new Properties();
            properties.load(in);
        } else {
            log.debug((Object)"No action artifact mapping");
        }
        return properties;
    }

    public static Set<ObjectName> getActionDependencies(String deploymentName, ModelAdapter model, Properties actionArtifactProperties) throws DeploymentException {
        int numActionClasses;
        HashSet<ObjectName> deps = new HashSet<ObjectName>();
        HashSet<String> artifacts = new HashSet<String>();
        artifacts.add(ESB_ARTIFACT_NAME);
        Set<String> actionClasses = model.getActions();
        int n = numActionClasses = actionClasses == null ? 0 : actionClasses.size();
        if (numActionClasses > 0) {
            for (String actionClass : actionClasses) {
                String artifact = (String)actionArtifactProperties.get(actionClass);
                if (artifact == null) continue;
                artifacts.add(artifact);
            }
        }
        for (String artifact : artifacts) {
            if (deploymentName.equals(artifact)) continue;
            String canonicalName = PREFIX_CANONICAL_NAME + artifact;
            try {
                ObjectName on = ObjectNameConverter.convert((String)canonicalName);
                deps.add(on);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
        }
        return deps;
    }
}

