/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.SecurityContextPropagator;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityContext;
import org.jboss.soa.esb.services.security.principals.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBossASContextPropagator
implements SecurityContextPropagator {
    @Override
    public void pushSecurityContext(SecurityContext context, Set<?> authCredentials, SecurityConfig config) {
        AssertArgument.isNotNull(context, "context");
        Subject subject = context.getSubject();
        Principal principal = this.getPrincipal(subject);
        Object credential = null;
        if (authCredentials != null && !authCredentials.isEmpty()) {
            credential = authCredentials.iterator().next();
        }
        SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, credential);
        if (this.isRunAsSet(config)) {
            SecurityAssociation.pushRunAsIdentity((RunAsIdentity)new RunAsIdentity(config.getRunAs(), principal.getName()));
        }
    }

    @Override
    public void popSecurityContext(SecurityContext context, SecurityConfig config) {
        SecurityAssociation.popSubjectContext();
        if (this.isRunAsSet(config)) {
            SecurityAssociation.popRunAsIdentity();
        }
    }

    private Principal getPrincipal(Subject subject) {
        Iterator<Principal> i$ = subject.getPrincipals().iterator();
        if (i$.hasNext()) {
            Principal principal = i$.next();
            return principal;
        }
        return new User("NullPrincipal");
    }

    private boolean isRunAsSet(SecurityConfig config) {
        return config != null && config.getRunAs() != null;
    }
}

