/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.PasswordUtil;

public class JAXRConnectionFactory {
    private static Logger logger = Logger.getLogger(JAXRConnectionFactory.class);
    private Set<PasswordAuthentication> creds = new HashSet<PasswordAuthentication>();
    private Properties props = new Properties();

    public JAXRConnectionFactory() throws ConfigurationException {
        if (Configuration.getRegistryQueryManageURI() == null) {
            throw new ConfigurationException("ESB property 'org.jboss.soa.esb.registry.queryManagerURI' not set.  ESB properties load may have failed.");
        }
        if (Configuration.getRegistryLifecycleManagerURI() == null) {
            throw new ConfigurationException("ESB property 'org.jboss.soa.esb.registry.lifeCycleManagerURI' not set.  ESB properties load may have failed.");
        }
        if (Configuration.getRegistryFactoryClass() == null) {
            throw new ConfigurationException("ESB property 'org.jboss.soa.esb.registry.factoryClass' not set.  ESB properties load may have failed.");
        }
        this.props.setProperty("javax.xml.registry.queryManagerURL", Configuration.getRegistryQueryManageURI());
        this.props.setProperty("javax.xml.registry.lifeCycleManagerURL", Configuration.getRegistryLifecycleManagerURI());
        this.props.setProperty("javax.xml.registry.factoryClass", Configuration.getRegistryFactoryClass());
        if (Configuration.getRegistrySemanticEquivalences() != null) {
            this.props.setProperty("javax.xml.registry.semanticEquivalences", Configuration.getRegistrySemanticEquivalences());
        }
        if (Configuration.getRegistryPostalAddressScheme() != null) {
            this.props.setProperty("javax.xml.registry.postalAddressScheme", Configuration.getRegistryPostalAddressScheme());
        }
        if (Configuration.getRegistrySecurityAuthenticationMethod() != null) {
            this.props.setProperty("javax.xml.registry.security.authenticationMethod", Configuration.getRegistrySecurityAuthenticationMethod());
        }
        if (Configuration.getRegistryUDDIMaxRows() != null) {
            this.props.setProperty("javax.xml.registry.uddi.maxRows", Configuration.getRegistryUDDIMaxRows());
        }
        if (Configuration.getRegistryScoutTransportClass() != null) {
            this.props.setProperty("scout.proxy.transportClass", Configuration.getRegistryScoutTransportClass());
        }
        if (Configuration.getRegistryUDDIVersion() != null) {
            this.props.setProperty("scout.proxy.uddiVersion", Configuration.getRegistryUDDIVersion());
        }
        if (Configuration.getRegistrySecurityManagerURI() != null) {
            this.props.setProperty("javax.xml.registry.securityManagerURL", Configuration.getRegistrySecurityManagerURI());
        }
        if (Configuration.getRegistryUDDINameSpace() != null) {
            this.props.setProperty("scout.proxy.uddiNamespace", Configuration.getRegistryUDDINameSpace());
        }
        String user = Configuration.getRegistryUser();
        String password = Configuration.getRegistryPassword();
        if (PasswordUtil.isPasswordFile(password)) {
            try {
                password = new PasswordUtil(password).getPasswordAsString();
            }
            catch (IOException e) {
                throw new ConfigurationException("Could not retrieve password from file", e);
            }
        }
        if (user == null || password == null) {
            throw new ConfigurationException("ESB property 'org.jboss.soa.esb.registry.user' or 'org.jboss.soa.esb.registry.password' not set.  ESB properties load may have failed.");
        }
        PasswordAuthentication passwdAuth = new PasswordAuthentication(user, password.toCharArray());
        this.creds.add(passwdAuth);
    }

    protected Connection getConnection() {
        Connection connection = null;
        try {
            ConnectionFactory factory = ConnectionFactory.newInstance();
            factory.setProperties(this.props);
            connection = factory.createConnection();
            connection.setCredentials(this.creds);
        }
        catch (JAXRException e) {
            logger.log((Priority)Level.ERROR, (Object)("Could not set up a connection to the Registry. " + e.getMessage()), (Throwable)e);
        }
        return connection;
    }

    protected void closeConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (JAXRException je) {
            logger.log((Priority)Level.ERROR, (Object)je.getMessage(), (Throwable)je);
        }
    }
}

