/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.List;
import org.jboss.internal.soa.esb.couriers.transport.InVMException;
import org.jboss.internal.soa.esb.couriers.transport.InVMTransport;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.services.registry.AbstractRegistryInterceptor;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InVMRegistryInterceptor
extends AbstractRegistryInterceptor {
    @Override
    public void registerEPR(String serviceCategoryName, String serviceName, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        if (epr instanceof InVMEpr) {
            try {
                InVMTransport.getInstance().registerEPR(serviceCategoryName, serviceName, (InVMEpr)epr);
            }
            catch (InVMException invme) {
                throw new RegistryException("Unexpected error registering service EPR", invme);
            }
        } else {
            this.getRegistry().registerEPR(serviceCategoryName, serviceName, serviceDescription, epr, eprDescription);
        }
    }

    @Override
    public void unRegisterService(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        block2: {
            boolean entryRemoved = InVMTransport.getInstance().unRegisterService(category, serviceName);
            try {
                this.getRegistry().unRegisterService(category, serviceName);
            }
            catch (ServiceNotFoundException snfe) {
                if (entryRemoved) break block2;
                throw snfe;
            }
        }
    }

    @Override
    public void unRegisterEPR(String serviceCategoryName, String serviceName, EPR epr) throws RegistryException, ServiceNotFoundException {
        if (epr instanceof InVMEpr) {
            InVMTransport.getInstance().unRegisterEPR(serviceCategoryName, serviceName, (InVMEpr)epr);
        } else {
            this.getRegistry().unRegisterEPR(serviceCategoryName, serviceName, epr);
        }
    }

    @Override
    public List<String> findAllServices() throws RegistryException {
        List<String> services = InVMTransport.getInstance().findAllServices();
        services.addAll(this.getRegistry().findAllServices());
        return services;
    }

    @Override
    public List<String> findServices(String serviceCategoryName) throws RegistryException {
        List<String> services = InVMTransport.getInstance().findServices(serviceCategoryName);
        services.addAll(this.getRegistry().findServices(serviceCategoryName));
        return services;
    }

    @Override
    public List<EPR> findEPRs(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
        List<EPR> eprs = InVMTransport.getInstance().findEPRs(serviceCategoryName, serviceName);
        if (eprs.size() == 0) {
            return this.getRegistry().findEPRs(serviceCategoryName, serviceName);
        }
        try {
            eprs.addAll(this.getRegistry().findEPRs(serviceCategoryName, serviceName));
        }
        catch (ServiceNotFoundException snfe) {
            // empty catch block
        }
        return eprs;
    }

    @Override
    public EPR findEPR(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
        EPR epr = InVMTransport.getInstance().findEPR(serviceCategoryName, serviceName);
        if (epr != null) {
            return epr;
        }
        return this.getRegistry().findEPR(serviceCategoryName, serviceName);
    }
}

