/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.remoting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jboss.internal.soa.esb.remoting.JBossRemotingUtil;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.http.HTTPMarshaller;
import org.jboss.soa.esb.listeners.gateway.JBossRemotingGatewayListener;

public class HttpMarshaller
extends HTTPMarshaller {
    public void write(Object object, OutputStream outputStream, int version) throws IOException {
        if (object instanceof InvocationResponse) {
            Object result = ((InvocationResponse)object).getResult();
            InvocationRequest currentRequest = JBossRemotingGatewayListener.getCurrentRequest();
            boolean sendJavaResponse = false;
            if (result != null && currentRequest != null) {
                Map requestMetadata = currentRequest.getRequestPayload();
                Map responseMetadata = currentRequest.getReturnPayload();
                String userAgent = (String)requestMetadata.get("User-Agent");
                sendJavaResponse = JBossRemotingUtil.sendJavaObjectPayload(responseMetadata, userAgent);
            }
            if (!sendJavaResponse) {
                if (result instanceof byte[]) {
                    outputStream.write((byte[])result);
                    outputStream.flush();
                } else {
                    super.write(result, outputStream, version);
                }
            } else {
                super.write(object, outputStream, version);
            }
        } else if (object instanceof byte[]) {
            outputStream.write((byte[])object);
            outputStream.flush();
        } else {
            super.write(object, outputStream, version);
        }
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new HttpMarshaller();
    }
}

