/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml.marshal;

import java.net.URI;
import org.jboss.internal.soa.esb.message.format.DeferredDeserialisationException;
import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalUnmarshalManager;
import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalUnmarshalPlugin;
import org.jboss.soa.esb.UnmarshalException;

public class MarshalValueImpl {
    private Object value;
    private String marshalledForm;
    private URI type;

    public MarshalValueImpl(Object value) {
        this.value = value;
    }

    public MarshalValueImpl(URI type, String marshalledForm) {
        this.type = type;
        this.marshalledForm = marshalledForm;
    }

    public Object getValue() {
        if (this.value == null && this.marshalledForm != null) {
            MarshalUnmarshalPlugin plugin = MarshalUnmarshalManager.getInstance().getPlugin(this.type);
            if (plugin == null) {
                throw new DeferredDeserialisationException("Could not locate plugin for type: " + this.type);
            }
            try {
                this.value = plugin.unmarshal(this.marshalledForm);
            }
            catch (UnmarshalException ue) {
                throw new DeferredDeserialisationException("Error constructing object value", ue);
            }
        }
        this.marshalledForm = null;
        return this.value;
    }

    URI getMarshalledType() {
        return this.type;
    }

    void setMarshalledType(URI type) {
        this.type = type;
    }

    String getMarshalledForm() {
        return this.marshalledForm;
    }

    void setMarshalledForm(String marshalledForm) {
        this.marshalledForm = marshalledForm;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "Deferred serialized value: " + Integer.toHexString(System.identityHashCode(this));
    }
}

