/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.message.format.xml.SerializedValueImpl;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.Encoding;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.TextElement;
import org.jboss.soa.esb.message.Properties;

public class PropertiesImpl
extends ElementContent
implements Properties {
    private HashMap<String, SerializedValueImpl> _table = new HashMap();

    public PropertiesImpl() {
    }

    public PropertiesImpl(XMLStreamReader in) throws XMLStreamException {
        this.parse(in);
    }

    public synchronized Object getProperty(String name) {
        return this.unwrap(this._table.get(name));
    }

    public Object getProperty(String name, Object defaultVal) {
        Object oRet = this.getProperty(name);
        return null == oRet ? defaultVal : oRet;
    }

    public synchronized Object setProperty(String name, Object value) {
        AssertArgument.isNotNull(name, "name");
        AssertArgument.isNotNull(value, "value");
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Value of property '" + name + "' must implement " + Serializable.class.getName() + ".  Value is of type " + value.getClass().getName());
        }
        return this.unwrap(this._table.put(name, new SerializedValueImpl((Serializable)value)));
    }

    public synchronized Object remove(String name) {
        return this.unwrap(this._table.remove(name));
    }

    public synchronized int size() {
        return this._table.size();
    }

    public synchronized String[] getNames() {
        return this._table.keySet().toArray(new String[0]);
    }

    protected synchronized void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        for (Map.Entry<String, SerializedValueImpl> entry : this._table.entrySet()) {
            String origPropertyURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_PROPERTY);
            TextElement keyElement = new TextElement(Encoding.encodeBytes(entry.getKey().getBytes()));
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_PROPERTY_KEY, keyElement);
            String value = entry.getValue().getSerialisedForm();
            TextElement valueElement = new TextElement(value);
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_PROPERTY_VALUE, valueElement);
            StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_PROPERTY.getPrefix(), origPropertyURI);
        }
    }

    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
        if (!XMLUtil.ESB_QNAME_PROPERTY.equals(elementName)) {
            throw new XMLStreamException("Unexpected element name: " + elementName);
        }
        StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_PROPERTY_KEY);
        TextElement keyElement = new TextElement(in);
        String key = new String(Encoding.decodeToBytes(keyElement.getText()));
        StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_PROPERTY_VALUE);
        TextElement valueElement = new TextElement(in);
        SerializedValueImpl value = new SerializedValueImpl(valueElement.getText());
        StreamHelper.checkParentFinished(in);
        this._table.put(key, value);
    }

    public synchronized String toString() {
        return "properties: [ " + this._table.toString() + " ]";
    }

    private Object unwrap(SerializedValueImpl value) {
        return value == null ? null : value.getValue();
    }
}

