/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalUnmarshalManager;
import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalValueImpl;
import org.jboss.internal.soa.esb.util.Encoding;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.TextElement;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyImpl
extends ElementContent
implements Body {
    private HashMap<String, MarshalValueImpl> _objects = new HashMap();

    public BodyImpl() {
    }

    public BodyImpl(XMLStreamReader in) throws XMLStreamException {
        this.parse(in);
    }

    @Override
    public void add(Object value) {
        this.add("org.jboss.soa.esb.message.defaultEntry", value);
    }

    @Override
    public synchronized void add(String name, Object value) {
        AssertArgument.isNotNull(value, "value");
        AssertArgument.isNotNull(name, "name");
        this._objects.put(name, new MarshalValueImpl(value));
    }

    @Override
    public Object get() {
        return this.get("org.jboss.soa.esb.message.defaultEntry");
    }

    @Override
    public synchronized Object get(String name) {
        AssertArgument.isNotNull(name, "name");
        return this.unwrap(this._objects.get(name));
    }

    @Override
    public synchronized String[] getNames() {
        Set<String> keys = this._objects.keySet();
        return keys.toArray(new String[0]);
    }

    public Enumeration<String> getEnumeratedNames() {
        return Collections.enumeration(Arrays.asList(this.getNames()));
    }

    @Override
    public synchronized Object remove(String name) {
        return this.unwrap(this._objects.remove(name));
    }

    @Override
    protected synchronized void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        byte[] content = this.getByteArray();
        if (content != null) {
            TextElement bytesContent = new TextElement(Encoding.encodeBytes(content));
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_BODY_BYTES_CONTENT, bytesContent);
        }
        for (Map.Entry<String, MarshalValueImpl> entry : this._objects.entrySet()) {
            String origContentURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT);
            TextElement key = new TextElement(Encoding.encodeBytes(entry.getKey().getBytes()));
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT_KEY, key);
            String origValueURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT_VALUE);
            if (!MarshalUnmarshalManager.getInstance().marshal(out, entry.getValue())) {
                throw new XMLStreamException("Cannot pack object:" + entry.getKey() + " " + entry.getValue());
            }
            StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT_VALUE.getPrefix(), origValueURI);
            StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT.getPrefix(), origContentURI);
        }
    }

    @Override
    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
        if (XMLUtil.ESB_QNAME_BODY_CONTENT.equals(elementName)) {
            StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_BODY_CONTENT_KEY);
            TextElement keyElement = new TextElement(in);
            String key = new String(Encoding.decodeToBytes(keyElement.getText()));
            StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_BODY_CONTENT_VALUE);
            MarshalValueImpl value = MarshalUnmarshalManager.getInstance().unmarshal(in);
            StreamHelper.checkParentFinished(in);
            StreamHelper.checkParentFinished(in);
            if (value == null) {
                throw new XMLStreamException("Cannot unpack object: " + key);
            }
            this._objects.put(key, value);
        } else if (XMLUtil.ESB_QNAME_BODY_BYTES_CONTENT.equals(elementName)) {
            TextElement textElement = new TextElement(in);
            String value = textElement.getText();
            if (value != null) {
                this.setByteArray(Encoding.decodeToBytes(value));
            } else {
                this.setByteArray(new byte[0]);
            }
        } else {
            throw new XMLStreamException("Unexpected element name: " + elementName);
        }
    }

    @Override
    public void setByteArray(byte[] content) {
        this.add("org.jboss.soa.esb.message.content.bytes", content);
    }

    @Override
    public byte[] getByteArray() {
        return (byte[])this.get("org.jboss.soa.esb.message.content.bytes");
    }

    @Override
    public void setContents(byte[] content) {
        this.setByteArray(content);
    }

    @Override
    public byte[] getContents() {
        return this.getByteArray();
    }

    @Override
    public void replace(Body b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        this.setByteArray(b.getByteArray());
        this._objects = ((BodyImpl)b)._objects;
    }

    @Override
    public void merge(Body b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        BodyImpl toMerge = null;
        if (!(b instanceof BodyImpl)) {
            throw new IllegalArgumentException();
        }
        toMerge = (BodyImpl)b;
        this._objects.putAll(toMerge._objects);
        byte[] toAdd = b.getByteArray();
        if (toAdd != null && toAdd.length > 0) {
            this.setByteArray(toAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder toReturn = new StringBuilder("body: [ ");
        byte[] content = this.getByteArray();
        if (content != null) {
            toReturn.append("byte[]: ").append(Util.format(new String(content))).append(", ");
        }
        BodyImpl bodyImpl = this;
        synchronized (bodyImpl) {
            toReturn.append("objects: ").append(this._objects);
        }
        return toReturn.append(" ]").toString();
    }

    protected BodyImpl(BodyImpl copy) {
        this._objects = copy._objects;
    }

    private Object unwrap(MarshalValueImpl value) {
        return value == null ? null : value.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseMap(Map<String, Serializable> payload) {
        BodyImpl bodyImpl = this;
        synchronized (bodyImpl) {
            this._objects.clear();
            for (Map.Entry<String, Serializable> entry : payload.entrySet()) {
                this._objects.put(entry.getKey(), new MarshalValueImpl(entry.getValue()));
            }
        }
    }
}

