/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.filter;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.addressing.eprs.HibernateEpr;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataFilter
extends InputOutputFilter {
    @Override
    public Message onOutput(Message msg, Map<String, Object> params) throws CourierException {
        String name;
        Environment.Transports type;
        EPR destination = msg.getHeader().getCall().getTo();
        if (destination != null) {
            if (destination instanceof FTPEpr) {
                try {
                    type = Environment.Transports.FTP;
                    String dir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.localdir", System.getProperty("java.io.tmpdir"));
                    name = dir + File.separator + msg.getHeader().getCall().getMessageID().toString() + ((FTPEpr)destination).getPostDirectory();
                }
                catch (Exception ex) {
                    throw new CourierException(ex);
                }
            } else if (destination instanceof FileEpr) {
                try {
                    type = Environment.Transports.File;
                    name = destination.getURI() + File.separator + msg.getHeader().getCall().getMessageID().toString() + ((FileEpr)destination).getInputSuffix();
                }
                catch (Exception ex) {
                    throw new CourierException(ex);
                }
            } else if (destination instanceof JMSEpr) {
                type = Environment.Transports.JMS;
                name = destination.getAddr().toString();
            } else if (destination instanceof JDBCEpr) {
                type = Environment.Transports.SQL;
                name = destination.getAddr().toString();
            } else if (destination instanceof HibernateEpr) {
                type = Environment.Transports.Hibernate;
                name = destination.getAddr().toString();
            } else {
                type = null;
                name = null;
            }
        } else {
            type = null;
            name = null;
        }
        Properties props = msg.getProperties();
        this.setProperty(props, "org.jboss.soa.esb.message.transport.type", (Object)type);
        this.setProperty(props, "org.jboss.soa.esb.message.source", name);
        props.setProperty("org.jboss.soa.esb.message.time.dob", new Date().toString());
        return msg;
    }

    @Override
    public Message onInput(Message msg, Map<String, Object> params) throws CourierException {
        msg.getProperties().setProperty("org.jboss.soa.esb.message.time.dod", new Date().toString());
        return msg;
    }

    private void setProperty(Properties props, String name, Object value) {
        if (value == null) {
            props.remove(name);
        } else {
            props.setProperty(name, value);
        }
    }
}

