/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.filter;

import java.io.File;
import java.util.Map;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayFilter
extends InputOutputFilter {
    @Override
    public Message onOutput(Message msg, Map<String, Object> params) throws CourierException {
        if (params != null) {
            ConfigTree config;
            File inFile = (File)params.get("org.jboss.soa.esb.gateway.file");
            if (inFile != null) {
                msg.getProperties().setProperty("org.jboss.soa.esb.gateway.original.file.name", inFile.getName());
            }
            if ((config = (ConfigTree)params.get("org.jboss.soa.esb.gateway.config")) != null) {
                try {
                    String url = ListenerUtil.getValue(config, "URL", null);
                    if (url != null) {
                        msg.getProperties().setProperty("org.jboss.soa.esb.gateway.original.url", url);
                    }
                }
                catch (Throwable ex) {
                    FilterManager._logger.warn((Object)"GatewayFilter encountered problem during JDBC config check.", ex);
                }
                try {
                    String queueName = ListenerUtil.getValue(config, "destination-name", null);
                    if (queueName != null) {
                        msg.getProperties().setProperty("org.jboss.soa.esb.gateway.original.queue.name", queueName);
                    }
                }
                catch (Throwable ex) {
                    FilterManager._logger.warn((Object)"GatewayFilter encountered problem during JMS config check.", ex);
                }
            }
        }
        return msg;
    }
}

