/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.listeners.war;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.listeners.war.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConstraints {
    private Servlet servlet;
    private Set<String> protectedMethods = new LinkedHashSet<String>();
    private Set<String> allowedRoles = new AllowedRoleSet();
    private String transportGuarantee;

    public SecurityConstraints(Servlet servlet) {
        AssertArgument.isNotNull(servlet, "servlet");
        this.servlet = servlet;
        servlet.setSecurityConstraints(this);
    }

    public Set<String> getProtectedMethods() {
        return this.protectedMethods;
    }

    public Set<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllowedRoleSet<T extends String>
    extends LinkedHashSet<String> {
        private AllowedRoleSet() {
        }

        @Override
        public boolean add(String role) {
            SecurityConstraints.this.servlet.getWebModel().getSecurityRoles().add(role);
            return super.add(role);
        }
    }
}

