/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.helpers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.SqlTableCourier;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.couriers.CourierServiceBindException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.util.ClassUtil;

public class JDBCEprDBResourceFactory {
    private static Logger logger = Logger.getLogger(JDBCEprDBResourceFactory.class);
    private JDBCEpr epr;
    private DataSource dataSource;
    private String insertStatementSQL;
    private String listStatementSQL;
    private String select4UpdateStatementSQL;
    private String updateStatusStatementSQL;
    private String updateRetryCountStatementSQL;
    private String deleteStatementSQL;
    private String selectPickupMessage;

    public JDBCEprDBResourceFactory(JDBCEpr epr) throws CourierServiceBindException {
        this.epr = epr;
        if (epr.getDatasource() != null) {
            this.lookupDataSource(epr);
        } else {
            try {
                ClassUtil.forName(epr.getDriver(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new CourierServiceBindException("Database driver '" + epr.getDriver() + "' not available on classpath.");
            }
        }
    }

    public Connection createConnection(boolean transactional) throws CourierTransportException, CourierServiceBindException {
        Connection connection;
        try {
            connection = this.dataSource != null ? this.dataSource.getConnection() : DriverManager.getConnection(this.epr.getURL(), this.epr.getUserName(), this.epr.getPassword());
        }
        catch (SQLException e) {
            throw new CourierTransportException("Failed to connect to DataSource.", e);
        }
        if (!transactional) {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    logger.error((Object)"Failed to close connection.", (Throwable)e1);
                }
                throw new CourierTransportException("Failed to turn off autoCommit on connection..", e);
            }
        }
        return connection;
    }

    public PreparedStatement createListStatement(Connection connection) throws SQLException {
        if (this.listStatementSQL == null) {
            this.listStatementSQL = this.buildListStatementSQL();
        }
        return connection.prepareStatement(this.listStatementSQL);
    }

    public PreparedStatement createSelect4UpdateStatement(Connection connection) throws SQLException {
        if (this.select4UpdateStatementSQL == null) {
            this.select4UpdateStatementSQL = this.buildSelect4UpdateStatementSQL();
        }
        return connection.prepareStatement(this.select4UpdateStatementSQL);
    }

    public PreparedStatement createSelectPickupMessage(Connection connection) throws SQLException {
        if (this.selectPickupMessage == null) {
            this.selectPickupMessage = this.buildSelectPickupMessage();
        }
        return connection.prepareStatement(this.selectPickupMessage);
    }

    public PreparedStatement createUpdateStatusStatement(Connection connection) throws SQLException {
        if (this.updateStatusStatementSQL == null) {
            this.updateStatusStatementSQL = this.buildUpdateStatusStatementSQL();
        }
        return connection.prepareStatement(this.updateStatusStatementSQL);
    }

    public PreparedStatement createUpdateRetryCountStatement(Connection connection) throws SQLException {
        if (this.updateRetryCountStatementSQL == null) {
            this.updateRetryCountStatementSQL = this.buildUpdateRetryCountStatementSQL();
        }
        return connection.prepareStatement(this.updateRetryCountStatementSQL);
    }

    public PreparedStatement createInsertStatement(Connection connection) throws SQLException {
        if (this.insertStatementSQL == null) {
            this.insertStatementSQL = this.buildInsertStatementSQL();
        }
        return connection.prepareStatement(this.insertStatementSQL);
    }

    public PreparedStatement createDeleteStatement(Connection connection) throws SQLException {
        if (this.deleteStatementSQL == null) {
            this.deleteStatementSQL = this.buildDeleteStatementSQL();
        }
        return connection.prepareStatement(this.deleteStatementSQL);
    }

    private String buildSelect4UpdateStatementSQL() {
        StringBuilder sb = new StringBuilder("select ");
        sb = sb.append(this.epr.getDataColumn()).append(" from ").append(this.epr.getTableName()).append(" where ").append(this.epr.getMessageIdColumn()).append(" = ?").append(" and ").append(this.epr.getStatusColumn()).append(" = ?");
        if (!this.epr.getURL().contains("hsqldb")) {
            sb.append(" for update");
        }
        return sb.toString();
    }

    private String buildSelectPickupMessage() {
        StringBuilder sb = new StringBuilder("select ");
        sb = sb.append(this.epr.getDataColumn()).append(" from ").append(this.epr.getTableName()).append(" where ").append(this.epr.getMessageIdColumn()).append(" = ?").append(" and ").append(this.epr.getStatusColumn()).append(" = ?").append(" and ").append(this.epr.getTimestampColumn()).append(" = ?");
        if (!this.epr.getURL().contains("hsqldb")) {
            sb.append(" for update");
        }
        return sb.toString();
    }

    private String buildUpdateStatusStatementSQL() {
        StringBuilder sb = new StringBuilder("update ").append(this.epr.getTableName()).append(" set ").append(this.epr.getStatusColumn()).append("= ?").append(" where ").append(this.epr.getMessageIdColumn()).append("=?");
        return sb.toString();
    }

    private String buildUpdateRetryCountStatementSQL() {
        StringBuilder sb = new StringBuilder("update ").append(this.epr.getTableName()).append(" set ").append(this.epr.getRetryCountColumn()).append("= ?, ").append(this.epr.getStatusColumn()).append("= ?, ").append(this.epr.getTimestampColumn()).append("= ?").append(" where ").append(this.epr.getMessageIdColumn()).append("=? and ").append(this.epr.getTimestampColumn()).append("=?");
        return sb.toString();
    }

    private String buildInsertStatementSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.epr.getTableName());
        sb.append(" (");
        sb.append(this.epr.getMessageIdColumn()).append(", ");
        sb.append(this.epr.getDataColumn()).append(", ");
        sb.append(this.epr.getStatusColumn()).append(", ");
        sb.append(this.epr.getTimestampColumn());
        sb.append(") values (?,?,?,?)");
        return sb.toString();
    }

    private String buildListStatementSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(this.epr.getMessageIdColumn()).append(", ");
        sb.append(this.epr.getTimestampColumn()).append(", ");
        sb.append(this.epr.getStatusColumn());
        String retryColumn = this.epr.getRetryCountColumn();
        if (retryColumn != null) {
            sb.append(", " + retryColumn);
        }
        sb.append(" from ").append(this.epr.getTableName());
        sb.append(" where ").append(this.epr.getStatusColumn());
        sb.append(" = '").append(SqlTableCourier.State.Pending.getColumnValue()).append("'");
        sb.append(" order by 2");
        return sb.toString();
    }

    private String buildDeleteStatementSQL() {
        StringBuilder sb = new StringBuilder("delete from ").append(this.epr.getTableName()).append(" where ").append(this.epr.getMessageIdColumn()).append(" =?");
        return sb.toString();
    }

    private void lookupDataSource(JDBCEpr epr) throws CourierServiceBindException {
        block4: {
            try {
                if (epr.getDatasource() == null) break block4;
                try {
                    InitialContext initContext = new InitialContext();
                    this.dataSource = (DataSource)initContext.lookup(epr.getDatasource());
                }
                catch (NamingException e) {
                    logger.error((Object)"Problem resolving DataSource through JNDI", (Throwable)e);
                    throw e;
                }
            }
            catch (Exception e) {
                throw new CourierServiceBindException("Failed to lookup DataSource.", e);
            }
        }
    }
}

