/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.FileCourier;
import org.jboss.internal.soa.esb.couriers.InVMCourier;
import org.jboss.internal.soa.esb.couriers.JmsCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.SqlTableCourier;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierTimeoutException;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.listeners.message.errors.Factory;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.util.Type;

public class TwoWayCourierImpl
implements TwoWayCourier {
    private DeliverOnlyCourier _deliverCourier;
    private EPR _toEPR;
    private PickUpOnlyCourier _pickupCourier;

    public TwoWayCourierImpl(DeliverOnlyCourier deliverCourier, PickUpOnlyCourier pickupCourier) {
        this._deliverCourier = deliverCourier;
        this._pickupCourier = pickupCourier;
    }

    public TwoWayCourierImpl(EPR toEpr, EPR replyToEpr) throws CourierException, MalformedEPRException {
        this.setToEpr(toEpr);
        this.setReplyToEpr(replyToEpr);
    }

    public void setToEpr(EPR toEPR) throws CourierException, MalformedEPRException {
        CourierUtil.cleanCourier(this._deliverCourier);
        this._deliverCourier = null;
        this._deliverCourier = this.getDeliverCourier(toEPR);
        this._toEPR = toEPR;
    }

    public void setReplyToEpr(EPR replyToEPR) throws CourierException, MalformedEPRException {
        CourierUtil.cleanCourier(this._pickupCourier);
        this._pickupCourier = null;
        this._pickupCourier = this.getPickupCourier(replyToEPR);
    }

    public PickUpOnlyCourier getPickupCourier() {
        return this._pickupCourier;
    }

    public DeliverOnlyCourier getDeliverCourier() {
        return this._deliverCourier;
    }

    private DeliverOnlyCourier getDeliverCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        return null == toEPR ? null : (DeliverOnlyCourier)this.courierFromEpr(toEPR, false);
    }

    private PickUpOnlyCourier getPickupCourier(EPR replyToEPR) throws CourierException, MalformedEPRException {
        return null == replyToEPR ? null : (PickUpOnlyCourier)this.courierFromEpr(replyToEPR, true);
    }

    private Object courierFromEpr(EPR epr, boolean pickUpOnly) throws CourierException, MalformedEPRException {
        if (null == epr) {
            return null;
        }
        if (epr instanceof InVMEpr) {
            return new InVMCourier((InVMEpr)epr);
        }
        if (epr instanceof JMSEpr) {
            return new JmsCourier((JMSEpr)epr, pickUpOnly);
        }
        if (epr instanceof FileEpr) {
            return new FileCourier((FileEpr)epr, pickUpOnly);
        }
        if (epr instanceof JDBCEpr) {
            return new SqlTableCourier((JDBCEpr)epr, pickUpOnly);
        }
        return this.courierFromGenericEPR(epr, pickUpOnly);
    }

    private Object courierFromGenericEPR(EPR epr, boolean pickUpOnly) throws CourierException, MalformedEPRException {
        String addr = null;
        addr = epr.getAddr().getAddress();
        if (addr.startsWith("invm")) {
            return new InVMCourier(new InVMEpr(epr));
        }
        if (addr.startsWith("jms")) {
            return new JmsCourier(new JMSEpr(epr), pickUpOnly);
        }
        if (addr.startsWith("jdbc")) {
            return new SqlTableCourier(new JDBCEpr(epr), pickUpOnly);
        }
        if (addr.startsWith("file://") || addr.startsWith("ftp://") || addr.startsWith("sftp://") || addr.startsWith("ftps://")) {
            return new FileCourier(new FileEpr(epr), pickUpOnly);
        }
        throw new MalformedEPRException("Courier for " + epr.getClass().getSimpleName() + " not supported: ESB-unaware EPR used!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deliver(Message message) throws CourierException, MalformedEPRException {
        boolean setMessageID;
        if (null == this._deliverCourier) {
            throw new CourierException("No deliverAsync courier");
        }
        Call call = message.getHeader().getCall();
        call.setTo(this._toEPR);
        boolean bl = setMessageID = call.getMessageID() == null;
        if (setMessageID) {
            String messageID = UUID.randomUUID().toString();
            try {
                call.setMessageID(new URI(messageID));
            }
            catch (URISyntaxException urise) {
                throw new MalformedEPRException("Failed to set message ID to " + messageID);
            }
        }
        try {
            message = FilterManager.getInstance().doOutputWork(message, null);
            boolean bl2 = this._deliverCourier.deliver(message);
            return bl2;
        }
        finally {
            if (setMessageID) {
                call.setMessageID(null);
            }
        }
    }

    public Message pickup(long waitTime) throws CourierException, CourierTimeoutException {
        Message message = this.pickup(waitTime, this._pickupCourier);
        if (message != null && Type.isFaultMessage(message)) {
            Factory.createExceptionFromFault(message);
        }
        return message;
    }

    public Message pickup(long waitTime, EPR epr) throws CourierException, CourierTimeoutException, MalformedEPRException {
        return this.pickup(waitTime, this.getPickupCourier(epr));
    }

    private Message pickup(long waitTime, PickUpOnlyCourier courier) throws CourierException, CourierTimeoutException {
        if (null == courier) {
            throw new CourierException("No courier defined for pick ups");
        }
        Message result = courier.pickup(waitTime);
        return result == null ? null : FilterManager.getInstance().doInputWork(result, null);
    }

    public void cleanup() {
        CourierUtil.cleanCourier(this._deliverCourier);
        this._deliverCourier = null;
        CourierUtil.cleanCourier(this._pickupCourier);
        this._pickupCourier = null;
        CourierFactory.deregisterCourier(this);
    }
}

