/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.internal.soa.esb.couriers.transport.InVMTemporaryTransport;
import org.jboss.internal.soa.esb.couriers.transport.InVMTransport;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.message.Message;

public class InVMCourier
implements PickUpOnlyCourier,
DeliverOnlyCourier {
    private static Logger logger = Logger.getLogger(InVMCourier.class);
    private final InVMEpr epr;

    public InVMCourier(InVMEpr epr) {
        this.epr = epr;
    }

    public boolean deliver(Message message) throws CourierException {
        if (message == null) {
            return false;
        }
        try {
            if (this.epr.isTemporaryEPR()) {
                InVMTemporaryTransport.getInstance().deliver(this.epr, message);
            } else {
                InVMTransport.getInstance().deliver(this.epr, message);
            }
            return true;
        }
        catch (Throwable ex) {
            logger.warn((Object)("InVMCourier delivery caught: " + ex));
            logger.debug((Object)"InVMCourier delivery caught", ex);
            return false;
        }
    }

    public Message pickup(long millis) throws CourierException {
        try {
            if (this.epr.isTemporaryEPR()) {
                return InVMTemporaryTransport.getInstance().pickup(this.epr, millis);
            }
            return InVMTransport.getInstance().pickup(this.epr, millis);
        }
        catch (Throwable ex) {
            logger.warn((Object)("InVMCourier pickup caught: " + ex));
            logger.debug((Object)"InVMCourier pickup caught", ex);
            return null;
        }
    }

    public void cleanup() {
    }
}

