/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.listener.ConnectionObserver;

public class SpyPanel
extends JPanel
implements ConnectionObserver {
    private static final long serialVersionUID = -8673659781727175707L;
    private JTextPane logTxt = null;
    private JTabbedPane parent = null;
    private JComponent defaultTab = null;
    private FtpServerContext serverContext = null;
    private Connection connection = null;
    private SimpleAttributeSet reqAttrs = null;
    private SimpleAttributeSet resAttrs = null;

    public SpyPanel(FtpServerContext serverContext, Connection con, JTabbedPane parent, JComponent defaultTab) {
        this.serverContext = serverContext;
        this.connection = con;
        this.parent = parent;
        this.defaultTab = defaultTab;
        this.initComponents();
        this.reqAttrs = new SimpleAttributeSet();
        StyleConstants.setForeground(this.reqAttrs, new Color(255, 0, 255));
        this.resAttrs = new SimpleAttributeSet();
        StyleConstants.setForeground(this.resAttrs, new Color(0, 0, 139));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.logTxt = new JTextPane();
        this.logTxt.setFont(new Font("Monospaced", 0, 12));
        this.logTxt.setEditable(false);
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(this.logTxt);
        this.add((Component)new JScrollPane(noWrapPanel), "Center");
        this.connection.setObserver((ConnectionObserver)this);
        JPanel bottomPane = new JPanel(new FlowLayout(1));
        JButton clearButton = new JButton("Clear");
        bottomPane.add(clearButton);
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpyPanel.this.clearLog();
            }
        });
        JButton disconnectButton = new JButton("Disconnect");
        bottomPane.add(disconnectButton);
        disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpyPanel.this.disconnectUser();
            }
        });
        JButton closeButton = new JButton("Close");
        bottomPane.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpyPanel.this.closePane();
            }
        });
        this.add((Component)bottomPane, "South");
    }

    public void response(final String msg) {
        Runnable runnable = new Runnable(){

            public void run() {
                Document doc = SpyPanel.this.logTxt.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg, SpyPanel.this.resAttrs);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void request(final String msg) {
        Runnable runnable = new Runnable(){

            public void run() {
                Document doc = SpyPanel.this.logTxt.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg, SpyPanel.this.reqAttrs);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void clearLog() {
        this.logTxt.setText("");
    }

    public void closePane() {
        this.parent.remove(this);
        if (this.parent.getTabCount() == 0) {
            this.parent.addTab("Spy", this.defaultTab);
        }
        this.connection.setObserver(null);
        this.clearLog();
    }

    private void disconnectUser() {
        boolean bConf = GuiUtils.getConfirmation(this, "Do you want to close the connection?");
        if (bConf) {
            ConnectionManager manager = this.serverContext.getConnectionManager();
            if (manager != null) {
                manager.closeConnection(this.connection);
            }
            this.connection.setObserver(null);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

