/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.util.DateUtils;

public class FtpFileTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2111896856959304666L;
    private static final int MAX_SIZE = 1000;
    private static final String[] COL_NAMES = new String[]{"File", "User", "Time"};
    private Vector entries = new Vector();

    public Class getColumnClass(int index) {
        return String.class;
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int index) {
        return COL_NAMES[index];
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
    }

    public Object getValueAt(int row, int col) {
        String retVal = "";
        TableEntry entry = null;
        try {
            entry = (TableEntry)this.entries.get(row);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (entry == null) {
            return retVal;
        }
        switch (col) {
            case 0: {
                retVal = entry.fileName;
                break;
            }
            case 1: {
                retVal = entry.userName;
                break;
            }
            case 2: {
                retVal = entry.date;
            }
        }
        return retVal;
    }

    public int findColumn(String columnName) {
        int index = -1;
        int i = COL_NAMES.length;
        while (--i >= 0) {
            if (!COL_NAMES[i].equals(columnName)) continue;
            index = i;
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newEntry(String file, User user) {
        String fileName = file;
        String userName = user.getName();
        String date = DateUtils.getISO8601Date((long)System.currentTimeMillis());
        TableEntry entry = new TableEntry(fileName, userName, date);
        int sz = this.entries.size();
        if (sz >= 1000) {
            this.clear();
            sz = 0;
        }
        Vector vector = this.entries;
        synchronized (vector) {
            this.entries.add(entry);
        }
        this.fireTableRowsInserted(++sz, sz);
    }

    public void clear() {
        this.entries.clear();
        this.fireTableDataChanged();
    }

    private static class TableEntry {
        final String fileName;
        final String userName;
        final String date;

        public TableEntry(String fileName, String userName, String date) {
            this.fileName = fileName;
            this.userName = userName;
            this.date = date;
        }
    }
}

