/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.samples.jpetstore.web.struts.BaseAction;
import org.springframework.util.StringUtils;

public class SearchProductsAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String keyword = request.getParameter("keyword");
        if (keyword != null) {
            if (!StringUtils.hasLength((String)keyword)) {
                request.setAttribute("message", (Object)"Please enter a keyword to search for, then press the search button.");
                return mapping.findForward("failure");
            }
            PagedListHolder productList = new PagedListHolder(this.getPetStore().searchProductList(keyword.toLowerCase()));
            productList.setPageSize(4);
            request.getSession().setAttribute("SearchProductsAction_productList", (Object)productList);
            request.setAttribute("productList", (Object)productList);
            return mapping.findForward("success");
        }
        String page = request.getParameter("page");
        PagedListHolder productList = (PagedListHolder)request.getSession().getAttribute("SearchProductsAction_productList");
        if (productList == null) {
            request.setAttribute("message", (Object)"Your session has timed out. Please start over again.");
            return mapping.findForward("failure");
        }
        if ("next".equals(page)) {
            productList.nextPage();
        } else if ("previous".equals(page)) {
            productList.previousPage();
        }
        request.setAttribute("productList", (Object)productList);
        return mapping.findForward("success");
    }
}

