/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.net.URI;
import org.apache.activemq.transport.TransportServerSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportServerThreadSupport
extends TransportServerSupport
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)TransportServerThreadSupport.class);
    private boolean daemon = true;
    private boolean joinOnStop = true;
    private Thread runner;

    public TransportServerThreadSupport() {
    }

    public TransportServerThreadSupport(URI location) {
        super(location);
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isJoinOnStop() {
        return this.joinOnStop;
    }

    public void setJoinOnStop(boolean joinOnStop) {
        this.joinOnStop = joinOnStop;
    }

    protected void doStart() throws Exception {
        log.info((Object)("Listening for connections at: " + this.getConnectURI()));
        this.runner = new Thread((Runnable)this, "ActiveMQ Transport Server: " + this.toString());
        this.runner.setDaemon(this.daemon);
        this.runner.setPriority(9);
        this.runner.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.runner != null && this.joinOnStop) {
            this.runner.join();
            this.runner = null;
        }
    }
}

