/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRef;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRefMarshaller;
import org.apache.activemq.store.kahadaptor.TopicSubAck;
import org.apache.activemq.store.kahadaptor.TopicSubContainer;

public class KahaTopicMessageStore
implements TopicMessageStore {
    private ActiveMQDestination destination;
    private ListContainer ackContainer;
    private ListContainer messageContainer;
    private Map subscriberContainer;
    private Store store;
    private Map subscriberMessages = new ConcurrentHashMap();
    static /* synthetic */ Class class$java$lang$String;

    public KahaTopicMessageStore(Store store, ListContainer messageContainer, ListContainer ackContainer, MapContainer subsContainer, ActiveMQDestination destination) throws IOException {
        this.messageContainer = messageContainer;
        this.destination = destination;
        this.store = store;
        this.ackContainer = ackContainer;
        this.subscriberContainer = subsContainer;
        Iterator i = this.subscriberContainer.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.addSubscriberMessageContainer(key);
        }
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        int subscriberCount = this.subscriberMessages.size();
        if (subscriberCount > 0) {
            StoreEntry messageEntry = this.messageContainer.placeLast(message);
            TopicSubAck tsa = new TopicSubAck();
            tsa.setCount(subscriberCount);
            tsa.setMessageEntry(messageEntry);
            StoreEntry ackEntry = this.ackContainer.placeLast(tsa);
            Iterator i = this.subscriberMessages.values().iterator();
            while (i.hasNext()) {
                TopicSubContainer container = (TopicSubContainer)i.next();
                ConsumerMessageRef ref = new ConsumerMessageRef();
                ref.setAckEntry(ackEntry);
                ref.setMessageEntry(messageEntry);
                container.getListContainer().add(ref);
            }
        }
    }

    public synchronized void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        TopicSubAck tsa;
        ConsumerMessageRef ref;
        String subcriberId = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = (TopicSubContainer)this.subscriberMessages.get(subcriberId);
        if (container != null && (ref = (ConsumerMessageRef)container.getListContainer().removeFirst()) != null && (tsa = (TopicSubAck)this.ackContainer.get(ref.getAckEntry())) != null) {
            if (tsa.decrementCount() <= 0) {
                this.ackContainer.remove(ref.getAckEntry());
                this.messageContainer.remove(tsa.getMessageEntry());
            } else {
                this.ackContainer.update(ref.getAckEntry(), tsa);
            }
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return (SubscriptionInfo)this.subscriberContainer.get(this.getSubscriptionKey(clientId, subscriptionName));
    }

    public synchronized void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        SubscriptionInfo info = new SubscriptionInfo();
        info.setDestination(this.destination);
        info.setClientId(clientId);
        info.setSelector(selector);
        info.setSubcriptionName(subscriptionName);
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.subscriberContainer.containsKey(key)) {
            this.subscriberContainer.put(key, info);
        }
        this.addSubscriberMessageContainer(key);
    }

    public synchronized void deleteSubscription(String clientId, String subscriptionName) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        this.subscriberContainer.remove(key);
        TopicSubContainer container = (TopicSubContainer)this.subscriberMessages.get(key);
        Iterator i = container.getListContainer().iterator();
        while (i.hasNext()) {
            TopicSubAck tsa;
            ConsumerMessageRef ref = (ConsumerMessageRef)i.next();
            if (ref == null || (tsa = (TopicSubAck)this.ackContainer.get(ref.getAckEntry())) == null) continue;
            if (tsa.decrementCount() <= 0) {
                this.ackContainer.remove(ref.getAckEntry());
                this.messageContainer.remove(tsa.getMessageEntry());
                continue;
            }
            this.ackContainer.update(ref.getAckEntry(), tsa);
        }
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = (TopicSubContainer)this.subscriberMessages.get(key);
        if (container != null) {
            Iterator i = container.getListContainer().iterator();
            while (i.hasNext()) {
                ConsumerMessageRef ref = (ConsumerMessageRef)i.next();
                Object msg = this.messageContainer.get(ref.getMessageEntry());
                if (msg != null) {
                    if (msg.getClass() == (class$java$lang$String == null ? KahaTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                        listener.recoverMessageReference((String)msg);
                    } else {
                        listener.recoverMessage((Message)msg);
                    }
                }
                listener.finished();
            }
        } else {
            listener.finished();
        }
    }

    public void recoverNextMessages(String clientId, String subscriptionName, MessageId lastMessageId, int maxReturned, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer container = (TopicSubContainer)this.subscriberMessages.get(key);
        if (container != null) {
            int count = 0;
            StoreEntry entry = container.getBatchEntry();
            if (entry == null) {
                entry = container.getListContainer().getFirst();
            } else {
                entry = container.getListContainer().refresh(entry);
                entry = container.getListContainer().getNext(entry);
            }
            if (entry != null) {
                do {
                    ConsumerMessageRef consumerRef;
                    Object msg;
                    if ((msg = this.messageContainer.get((consumerRef = (ConsumerMessageRef)container.getListContainer().get(entry)).getMessageEntry())) != null) {
                        if (msg.getClass() == (class$java$lang$String == null ? KahaTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                            String ref = msg.toString();
                            listener.recoverMessageReference(ref);
                        } else {
                            Message message = (Message)msg;
                            listener.recoverMessage(message);
                        }
                        ++count;
                    }
                    container.setBatchEntry(entry);
                } while ((entry = container.getListContainer().getNext(entry)) != null && count < maxReturned);
            }
        }
        listener.finished();
    }

    public void delete() {
        this.messageContainer.clear();
        this.ackContainer.clear();
        this.subscriberContainer.clear();
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.subscriberContainer.values().toArray(new SubscriptionInfo[this.subscriberContainer.size()]);
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    protected void addSubscriberMessageContainer(Object key) throws IOException {
        ListContainer container = this.store.getListContainer(key, "topic-subs");
        ConsumerMessageRefMarshaller marshaller = new ConsumerMessageRefMarshaller();
        container.setMarshaller(marshaller);
        TopicSubContainer tsc = new TopicSubContainer(container);
        this.subscriberMessages.put(key, tsc);
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        String key = this.getSubscriptionKey(clientId, subscriberName);
        TopicSubContainer container = (TopicSubContainer)this.subscriberMessages.get(key);
        return container.getListContainer().size();
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        this.messageContainer.add(messageRef);
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public Message getMessage(MessageId identity) throws IOException {
        Message result = null;
        Iterator i = this.messageContainer.iterator();
        while (i.hasNext()) {
            Message msg = (Message)i.next();
            if (!msg.getMessageId().equals(identity)) continue;
            result = msg;
            break;
        }
        return result;
    }

    public String getMessageReference(MessageId identity) throws IOException {
        return null;
    }

    public void recover(MessageRecoveryListener listener) throws Exception {
        Iterator iter = this.messageContainer.iterator();
        while (iter.hasNext()) {
            Object msg = iter.next();
            if (msg.getClass() == (class$java$lang$String == null ? KahaTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                listener.recoverMessageReference((String)msg);
                continue;
            }
            listener.recoverMessage((Message)msg);
        }
        listener.finished();
    }

    public synchronized void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageContainer.clear();
        this.ackContainer.clear();
        Iterator i = this.subscriberMessages.values().iterator();
        while (i.hasNext()) {
            TopicSubContainer container = (TopicSubContainer)i.next();
            container.getListContainer().clear();
        }
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        Iterator i = this.messageContainer.iterator();
        while (i.hasNext()) {
            Message msg = (Message)i.next();
            if (!msg.getMessageId().equals(ack.getLastMessageId())) continue;
            i.remove();
            break;
        }
    }

    public void setUsageManager(UsageManager usageManager) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized void resetBatching(String clientId, String subscriptionName, MessageId nextToDispatch) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        TopicSubContainer topicSubContainer = (TopicSubContainer)this.subscriberMessages.get(key);
        if (topicSubContainer != null) {
            topicSubContainer.reset();
            if (nextToDispatch != null) {
                StoreEntry entry = topicSubContainer.getListContainer().getFirst();
                do {
                    ConsumerMessageRef consumerRef;
                    Object msg;
                    if ((msg = this.messageContainer.get((consumerRef = (ConsumerMessageRef)topicSubContainer.getListContainer().get(entry)).getMessageEntry())) == null) continue;
                    if (msg.getClass() == (class$java$lang$String == null ? KahaTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                        String ref = msg.toString();
                        if (!msg.toString().equals(nextToDispatch.toString())) continue;
                        topicSubContainer.setBatchEntry(topicSubContainer.getListContainer().getPrevious(entry));
                        break;
                    }
                    Message message = (Message)msg;
                    if (message == null || !message.getMessageId().equals(nextToDispatch)) continue;
                    topicSubContainer.setBatchEntry(topicSubContainer.getListContainer().getPrevious(entry));
                    break;
                } while ((entry = topicSubContainer.getListContainer().getNext(entry)) != null);
            }
        }
    }

    public MessageId getNextMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws IOException {
        return null;
    }

    public MessageId getPreviousMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws IOException {
        return null;
    }
}

