/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.jms.DestinationBridge;
import org.apache.activemq.network.jms.JmsMesageConvertor;
import org.apache.activemq.network.jms.SimpleJmsMessageConvertor;
import org.apache.activemq.util.LRUCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiTemplate;

public abstract class JmsConnector
implements Service {
    private static final Log log = LogFactory.getLog((Class)JmsConnector.class);
    protected JndiTemplate jndiLocalTemplate;
    protected JndiTemplate jndiOutboundTemplate;
    protected JmsMesageConvertor inboundMessageConvertor;
    protected JmsMesageConvertor outboundMessageConvertor;
    private List inboundBridges = new CopyOnWriteArrayList();
    private List outboundBridges = new CopyOnWriteArrayList();
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected ActiveMQConnectionFactory embeddedConnectionFactory;
    protected int replyToDestinationCacheSize = 10000;
    protected String outboundUsername;
    protected String outboundPassword;
    protected String localUsername;
    protected String localPassword;
    private String name;
    protected LRUCache replyToBridges = JmsConnector.createLRUCache();
    static int nextId;

    private static LRUCache createLRUCache() {
        return new LRUCache(){
            private static final long serialVersionUID = -7446792754185879286L;

            protected boolean removeEldestEntry(Map.Entry enty) {
                if (this.size() > this.maxCacheSize) {
                    Iterator iter = this.entrySet().iterator();
                    Map.Entry lru = iter.next();
                    this.remove(lru.getKey());
                    DestinationBridge bridge = (DestinationBridge)lru.getValue();
                    try {
                        bridge.stop();
                        log.info((Object)("Expired bridge: " + bridge));
                    }
                    catch (Exception e) {
                        log.warn((Object)("stopping expired bridge" + bridge + " caused an exception"), (Throwable)e);
                    }
                }
                return false;
            }
        };
    }

    public boolean init() {
        boolean result = this.initialized.compareAndSet(false, true);
        if (result) {
            if (this.jndiLocalTemplate == null) {
                this.jndiLocalTemplate = new JndiTemplate();
            }
            if (this.jndiOutboundTemplate == null) {
                this.jndiOutboundTemplate = new JndiTemplate();
            }
            if (this.inboundMessageConvertor == null) {
                this.inboundMessageConvertor = new SimpleJmsMessageConvertor();
            }
            if (this.outboundMessageConvertor == null) {
                this.outboundMessageConvertor = new SimpleJmsMessageConvertor();
            }
            this.replyToBridges.setMaxCacheSize(this.getReplyToDestinationCacheSize());
        }
        return result;
    }

    public void start() throws Exception {
        this.init();
        if (this.started.compareAndSet(false, true)) {
            DestinationBridge bridge;
            int i;
            for (i = 0; i < this.inboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.inboundBridges.get(i);
                bridge.start();
            }
            for (i = 0; i < this.outboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.outboundBridges.get(i);
                bridge.start();
            }
            log.info((Object)("JMS Connector " + this.getName() + " Started"));
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            DestinationBridge bridge;
            int i;
            for (i = 0; i < this.inboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.inboundBridges.get(i);
                bridge.stop();
            }
            for (i = 0; i < this.outboundBridges.size(); ++i) {
                bridge = (DestinationBridge)this.outboundBridges.get(i);
                bridge.stop();
            }
            log.info((Object)("JMS Connector " + this.getName() + " Stopped"));
        }
    }

    protected abstract Destination createReplyToBridge(Destination var1, Connection var2, Connection var3);

    public void setBrokerService(BrokerService service) {
        this.embeddedConnectionFactory = new ActiveMQConnectionFactory(service.getVmConnectorURI());
    }

    public JndiTemplate getJndiLocalTemplate() {
        return this.jndiLocalTemplate;
    }

    public void setJndiLocalTemplate(JndiTemplate jndiTemplate) {
        this.jndiLocalTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiOutboundTemplate() {
        return this.jndiOutboundTemplate;
    }

    public void setJndiOutboundTemplate(JndiTemplate jndiOutboundTemplate) {
        this.jndiOutboundTemplate = jndiOutboundTemplate;
    }

    public JmsMesageConvertor getInboundMessageConvertor() {
        return this.inboundMessageConvertor;
    }

    public void setInboundMessageConvertor(JmsMesageConvertor jmsMessageConvertor) {
        this.inboundMessageConvertor = jmsMessageConvertor;
    }

    public JmsMesageConvertor getOutboundMessageConvertor() {
        return this.outboundMessageConvertor;
    }

    public void setOutboundMessageConvertor(JmsMesageConvertor outboundMessageConvertor) {
        this.outboundMessageConvertor = outboundMessageConvertor;
    }

    public int getReplyToDestinationCacheSize() {
        return this.replyToDestinationCacheSize;
    }

    public void setReplyToDestinationCacheSize(int replyToDestinationCacheSize) {
        this.replyToDestinationCacheSize = replyToDestinationCacheSize;
    }

    public String getLocalPassword() {
        return this.localPassword;
    }

    public void setLocalPassword(String localPassword) {
        this.localPassword = localPassword;
    }

    public String getLocalUsername() {
        return this.localUsername;
    }

    public void setLocalUsername(String localUsername) {
        this.localUsername = localUsername;
    }

    public String getOutboundPassword() {
        return this.outboundPassword;
    }

    public void setOutboundPassword(String outboundPassword) {
        this.outboundPassword = outboundPassword;
    }

    public String getOutboundUsername() {
        return this.outboundUsername;
    }

    public void setOutboundUsername(String outboundUsername) {
        this.outboundUsername = outboundUsername;
    }

    protected void addInboundBridge(DestinationBridge bridge) {
        this.inboundBridges.add(bridge);
    }

    protected void addOutboundBridge(DestinationBridge bridge) {
        this.outboundBridges.add(bridge);
    }

    protected void removeInboundBridge(DestinationBridge bridge) {
        this.inboundBridges.add(bridge);
    }

    protected void removeOutboundBridge(DestinationBridge bridge) {
        this.outboundBridges.add(bridge);
    }

    public String getName() {
        if (this.name == null) {
            this.name = "Connector:" + JmsConnector.getNextId();
        }
        return this.name;
    }

    private static synchronized int getNextId() {
        return nextId++;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void restartProducerConnection() throws NamingException, JMSException;
}

