/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.data;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.data.DataFile;
import org.apache.activemq.kaha.impl.data.DataItem;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.util.DataByteArrayOutputStream;

final class StoreDataWriter {
    private DataByteArrayOutputStream buffer;
    private DataManager dataManager;

    StoreDataWriter(DataManager fileManager) {
        this.dataManager = fileManager;
        this.buffer = new DataByteArrayOutputStream();
    }

    StoreLocation storeItem(Marshaller marshaller, Object payload, byte type) throws IOException {
        this.buffer.reset();
        this.buffer.position(5);
        marshaller.writePayload(payload, this.buffer);
        int size = this.buffer.size();
        int payloadSize = size - 5;
        this.buffer.reset();
        this.buffer.writeByte(type);
        this.buffer.writeInt(payloadSize);
        DataItem item = new DataItem();
        item.setSize(payloadSize);
        DataFile dataFile = this.dataManager.findSpaceForData(item);
        dataFile.getRandomAccessFile().seek(item.getOffset());
        dataFile.getRandomAccessFile().write(this.buffer.getData(), 0, size);
        dataFile.incrementLength(size);
        this.dataManager.addInterestInFile(dataFile);
        return item;
    }

    void updateItem(StoreLocation location, Marshaller marshaller, Object payload, byte type) throws IOException {
        this.buffer.reset();
        this.buffer.position(5);
        marshaller.writePayload(payload, this.buffer);
        int size = this.buffer.size();
        int payloadSize = size - 5;
        this.buffer.reset();
        this.buffer.writeByte(type);
        this.buffer.writeInt(payloadSize);
        RandomAccessFile dataFile = this.dataManager.getDataFile(location);
        dataFile.seek(location.getOffset());
        dataFile.write(this.buffer.getData(), 0, size);
    }
}

