/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;
import org.jboss.wsf.stack.cxf.resolver.JBossWSResourceResolver;
import org.jboss.wsf.stack.cxf.transport.SoapTransportFactoryExt;

public class BusDeploymentAspect
extends AbstractDeploymentAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Deployment dep) {
        BusHolder holder;
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            ArchiveDeployment aDep = (ArchiveDeployment)dep;
            SecurityActions.setContextClassLoader(dep.getRuntimeClassLoader());
            ResourceResolver deploymentResolver = aDep.getResourceResolver();
            URL cxfServletURL = null;
            try {
                cxfServletURL = deploymentResolver.resolve("WEB-INF/cxf-servlet.xml");
            }
            catch (IOException e) {
                // empty catch block
            }
            holder = BusHolder.create(cxfServletURL);
            Map contextParams = (Map)dep.getProperty("stack.context.parameters");
            try {
                URL jbossCxfXml = deploymentResolver.resolve((String)contextParams.get("jbossws.cxf.beans.url"));
                JBossWSResourceResolver resolver = new JBossWSResourceResolver(deploymentResolver);
                Configurer configurer = holder.createServerConfigurer((BindingCustomization)dep.getAttachment(BindingCustomization.class), new WSDLFilePublisher(aDep));
                holder.configure(jbossCxfXml, new SoapTransportFactoryExt(), resolver, configurer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            BusFactory.setDefaultBus(null);
            BusFactory.setThreadDefaultBus(null);
            SecurityActions.setContextClassLoader(origClassLoader);
        }
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            endpoint.addAttachment(BusHolder.class, (Object)holder);
        }
        dep.addAttachment(BusHolder.class, (Object)holder);
    }

    public void stop(Deployment dep) {
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            BusHolder holder = (BusHolder)endpoint.removeAttachment(BusHolder.class);
            if (holder == null) continue;
            holder.close();
        }
        BusHolder holder = (BusHolder)dep.removeAttachment(BusHolder.class);
        if (holder != null) {
            holder.close();
        }
    }
}

