/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.instrument.classloading.ClassFileTransformer2Translator;
import org.jboss.instrument.classloading.ReflectionHelper;
import org.jboss.util.loading.Translator;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.Assert;

public abstract class JBoss5ClassLoader
extends ReflectionHelper {
    private final BaseClassLoader classLoader;
    private ClassLoaderPolicy policy;

    protected JBoss5ClassLoader(BaseClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        this.classLoader = classLoader;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                AccessController.doPrivileged(new InstantiationAction());
            } else {
                this.doInstantiate();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize JBoss ClassLoader because JBoss5 API classes are not available", e);
        }
    }

    protected ClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    private void doInstantiate() throws Exception {
        Method getPolicy = JBoss5ClassLoader.getMethod(BaseClassLoader.class, "getPolicy");
        this.policy = JBoss5ClassLoader.invokeMethod(getPolicy, this.classLoader, ClassLoaderPolicy.class);
        this.fallbackStrategy();
    }

    protected void fallbackStrategy() throws Exception {
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, (String)"ClassFileTransformer must not be null");
        ClassFileTransformer2Translator translator = new ClassFileTransformer2Translator(transformer);
        this.addTranslator(translator);
    }

    protected abstract void addTranslator(Translator var1);

    public ClassLoader getInternalClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader((ClassLoader)this.classLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InstantiationAction
    implements PrivilegedExceptionAction<Object> {
        private InstantiationAction() {
        }

        @Override
        public Object run() throws Exception {
            JBoss5ClassLoader.this.doInstantiate();
            return null;
        }
    }
}

