/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Exchanger {
    private final Object lock;
    private Object item;
    private int arrivalCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object doExchange(Object x, boolean timed, long nanos) throws InterruptedException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            int count;
            long l = timed ? Utils.nanoTime() + nanos : 0L;
            long deadline = l;
            while (this.arrivalCount == 2) {
                if (!timed) {
                    this.lock.wait();
                    continue;
                }
                if (nanos <= 0L) {
                    throw new TimeoutException();
                }
                TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                nanos = deadline - Utils.nanoTime();
            }
            if ((count = ++this.arrivalCount) == 2) {
                Object other = this.item;
                this.item = x;
                this.lock.notifyAll();
                return other;
            }
            this.item = x;
            InterruptedException interrupted = null;
            try {
                while (this.arrivalCount != 2) {
                    if (!timed) {
                        this.lock.wait();
                        continue;
                    }
                    if (nanos > 0L) {
                        TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                interrupted = ie;
            }
            Object other = this.item;
            this.item = null;
            count = this.arrivalCount;
            this.arrivalCount = 0;
            this.lock.notifyAll();
            if (count == 2) {
                if (interrupted != null) {
                    Thread.currentThread().interrupt();
                }
                return other;
            }
            if (interrupted != null) {
                throw interrupted;
            }
            throw new TimeoutException();
        }
    }

    public Object exchange(Object x) throws InterruptedException {
        try {
            return this.doExchange(x, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            throw new Error(cannotHappen);
        }
    }

    public Object exchange(Object x, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        return this.doExchange(x, true, unit.toNanos(timeout));
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
    }

    public Exchanger() {
        this.this();
    }
}

