/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.factory;

import java.util.ArrayList;
import org.drools.process.core.timer.Timer;
import org.drools.ruleflow.core.RuleFlowNodeContainerFactory;
import org.drools.ruleflow.core.factory.NodeFactory;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.MilestoneNode;

public class MilestoneNodeFactory
extends NodeFactory {
    public MilestoneNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
    }

    protected Node createNode() {
        return new MilestoneNode();
    }

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    public MilestoneNodeFactory name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public MilestoneNodeFactory onEntryAction(String dialect, String action) {
        if (this.getMilestoneNode().getActions(dialect) != null) {
            this.getMilestoneNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getMilestoneNode().setActions("onEntry", actions);
        }
        return this;
    }

    public MilestoneNodeFactory onExitAction(String dialect, String action) {
        if (this.getMilestoneNode().getActions(dialect) != null) {
            this.getMilestoneNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getMilestoneNode().setActions("onExit", actions);
        }
        return this;
    }

    public MilestoneNodeFactory constraint(String constraint) {
        this.getMilestoneNode().setConstraint(constraint);
        return this;
    }

    public MilestoneNodeFactory timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getMilestoneNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }
}

