/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.util;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.ValueRetriever;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.connector.jdbc.util.ValueTranslatorAdaptor;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JDBCExecutionHelper {
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public static Class[] getColumnDataTypes(ICommand command) {
        Class[] dataTypes = null;
        if (command instanceof IQuery) {
            List selectSymbols = ((IQuery)command).getSelect().getSelectSymbols();
            dataTypes = new Class[selectSymbols.size()];
            Iterator iterator = selectSymbols.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                ISelectSymbol selectSymbol = (ISelectSymbol)iterator.next();
                dataTypes[i] = selectSymbol.getExpression().getType();
                ++i;
            }
        }
        return dataTypes;
    }

    public static boolean isLargeSetQuery(ICommand command, int batchSize) {
        if (batchSize <= 0) {
            return false;
        }
        ICriteria crit = ((IQuery)command).getWhere();
        if (crit == null) {
            return false;
        }
        if (crit instanceof IInCriteria) {
            return JDBCExecutionHelper.hasLargeSet((IInCriteria)crit, batchSize);
        }
        if (crit instanceof ICompoundCriteria) {
            ICompoundCriteria compCrit = (ICompoundCriteria)crit;
            if (compCrit.getOperator() == 1) {
                return false;
            }
            Iterator iter = compCrit.getCriteria().iterator();
            while (iter.hasNext()) {
                Object subCrit = iter.next();
                if (!(subCrit instanceof IInCriteria) || !JDBCExecutionHelper.hasLargeSet((IInCriteria)subCrit, batchSize)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static List getLargeSetSqls(IQuery query, int batchSize, ILanguageFactory langFactory) {
        ICriteria crit = query.getWhere();
        ArrayList<IQuery> commands = new ArrayList<IQuery>();
        if (crit instanceof IInCriteria) {
            List subCriteria = JDBCExecutionHelper.breakSetCriteria((IInCriteria)crit, batchSize, langFactory);
            Iterator iter = subCriteria.iterator();
            while (iter.hasNext()) {
                IQuery subQuery = langFactory.createQuery(query.getSelect(), query.getFrom(), (ICriteria)iter.next(), query.getGroupBy(), query.getHaving(), query.getOrderBy());
                commands.add(subQuery);
            }
        } else {
            ICompoundCriteria compCrit = (ICompoundCriteria)crit;
            IInCriteria bigCrit = null;
            Iterator subCritIter = compCrit.getCriteria().iterator();
            while (subCritIter.hasNext()) {
                IInCriteria setCrit;
                Object subCrit = subCritIter.next();
                if (!(subCrit instanceof IInCriteria) || (setCrit = (IInCriteria)subCrit).getRightExpressions().size() <= batchSize) continue;
                bigCrit = setCrit;
                subCritIter.remove();
                break;
            }
            List subCriteria = JDBCExecutionHelper.breakSetCriteria(bigCrit, batchSize, langFactory);
            Iterator iter = subCriteria.iterator();
            while (iter.hasNext()) {
                ICompoundCriteria newCrit = langFactory.createCompoundCriteria(compCrit.getOperator(), new ArrayList(compCrit.getCriteria()));
                IQuery subQuery = langFactory.createQuery(query.getSelect(), query.getFrom(), (ICriteria)newCrit, query.getGroupBy(), query.getHaving(), query.getOrderBy());
                newCrit.getCriteria().add(iter.next());
                commands.add(subQuery);
            }
        }
        return commands;
    }

    public static Batch createBatch(int updateCount) {
        BasicBatch batch = new BasicBatch();
        ArrayList<Integer> row = new ArrayList<Integer>(1);
        row.add(new Integer(updateCount));
        batch.addRow(row);
        batch.setLast();
        return batch;
    }

    public static Batch createBatch(List spResults, Class[] columnDataTypes, int maxBatchSize, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        BasicBatch batch = new BasicBatch();
        JDBCExecutionHelper.transferResults((Batch)batch, spResults, columnDataTypes, maxBatchSize, true, trimStrings, resultsTranslator, context);
        return batch;
    }

    public static Batch createBatch(ResultSet results, Class[] columnDataTypes, int maxBatchSize, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        BasicBatch batch = new BasicBatch();
        JDBCExecutionHelper.transferResults((Batch)batch, results, columnDataTypes, maxBatchSize, true, trimStrings, resultsTranslator, context);
        return batch;
    }

    public static void fillBatch(Batch batch, ResultSet results, Class[] columnDataTypes, int maxBatchSize, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        JDBCExecutionHelper.transferResults(batch, results, columnDataTypes, maxBatchSize, false, trimStrings, resultsTranslator, context);
    }

    private static boolean hasLargeSet(IInCriteria setCrit, int batchSize) {
        return !setCrit.isNegated() && setCrit.getRightExpressions().size() > batchSize;
    }

    protected static void transferResults(Batch batch, List spResults, Class[] columnTypes, int maxBatchSize, boolean setLastBatch, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        boolean[] trimColumn = new boolean[columnTypes.length];
        if (trimStrings) {
            for (int i = 0; i < columnTypes.length; ++i) {
                if (!columnTypes[i].equals(class$java$lang$String == null ? JDBCExecutionHelper.class$("java.lang.String") : class$java$lang$String)) continue;
                trimColumn[i] = true;
            }
        }
        boolean[] transformKnown = new boolean[columnTypes.length];
        ValueTranslator[] transforms = new ValueTranslator[columnTypes.length];
        ArrayList vals = null;
        int numCols = columnTypes.length;
        TimeZone dbmsTimeZone = resultsTranslator.getDatabaseTimezone();
        try {
            int rowCnt;
            for (rowCnt = 0; rowCnt < maxBatchSize && rowCnt < spResults.size(); ++rowCnt) {
                vals = new ArrayList(numCols);
                List valueList = (List)spResults.get(rowCnt);
                for (int i = 0; i < numCols; ++i) {
                    Object value = valueList.get(i);
                    if (value != null) {
                        if (!transformKnown[i]) {
                            Class<?> valueType = value.getClass();
                            if (valueType != columnTypes[i]) {
                                transforms[i] = JDBCExecutionHelper.determineTransformation(valueType, columnTypes[i], resultsTranslator.getValueTranslators());
                            }
                            transformKnown[i] = true;
                        }
                        if (transforms[i] != null) {
                            value = transforms[i].translate(value, context);
                        }
                        value = JDBCExecutionHelper.modifyTimeZone(value, dbmsTimeZone);
                        if (trimColumn[i]) {
                            value = JDBCExecutionHelper.trimString((String)value);
                        }
                    }
                    vals.add(value);
                }
                batch.addRow(vals);
            }
            if (rowCnt < maxBatchSize && setLastBatch) {
                batch.setLast();
            }
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConnectorException(e, JDBCPlugin.Util.getString("JDBCTranslator.Unknown_error_translating_results___9", (Object)e.getMessage()));
        }
    }

    protected static void transferResults(Batch batch, ResultSet results, Class[] columnTypes, int maxBatchSize, boolean setLastBatch, boolean trimStrings, ResultsTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        if (results == null) {
            return;
        }
        boolean[] trimColumn = new boolean[columnTypes.length];
        try {
            ResultSetMetaData rsmd = results.getMetaData();
            for (int i = 0; i < columnTypes.length; ++i) {
                if (!columnTypes[i].equals(class$java$lang$String == null ? JDBCExecutionHelper.class$("java.lang.String") : class$java$lang$String) || !trimStrings && rsmd.getColumnType(i + 1) != 1) continue;
                trimColumn[i] = true;
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage());
        }
        boolean[] transformKnown = new boolean[columnTypes.length];
        ValueTranslator[] transforms = new ValueTranslator[columnTypes.length];
        ArrayList<Object> vals = null;
        int numCols = columnTypes.length;
        List valueTranslators = resultsTranslator.getValueTranslators();
        ValueRetriever valueRetriever = resultsTranslator.getValueRetriever();
        TimeZone dbmsTimeZone = resultsTranslator.getDatabaseTimezone();
        try {
            int rowCnt;
            for (rowCnt = 0; rowCnt < maxBatchSize && results.next(); ++rowCnt) {
                vals = new ArrayList<Object>(numCols);
                for (int i = 0; i < numCols; ++i) {
                    Object value = valueRetriever.retrieveValue(results, i + 1, columnTypes[i]);
                    if (value != null) {
                        if (!transformKnown[i]) {
                            Class<?> valueType = value.getClass();
                            if (!columnTypes[i].isAssignableFrom(valueType)) {
                                transforms[i] = JDBCExecutionHelper.determineTransformation(valueType, columnTypes[i], valueTranslators);
                            }
                            transformKnown[i] = true;
                        }
                        if (transforms[i] != null) {
                            value = transforms[i].translate(value, context);
                        }
                        value = JDBCExecutionHelper.modifyTimeZone(value, dbmsTimeZone);
                        if (trimColumn[i]) {
                            value = JDBCExecutionHelper.trimString((String)value);
                        }
                    }
                    vals.add(value);
                }
                batch.addRow(vals);
            }
            if (rowCnt < maxBatchSize && setLastBatch) {
                batch.setLast();
            }
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e), JDBCPlugin.Util.getString("JDBCTranslator.Unexpected_exception_translating_results___8", (Object)e.getMessage()));
        }
        catch (Throwable e) {
            throw new ConnectorException(e, JDBCPlugin.Util.getString("JDBCTranslator.Unknown_error_translating_results___9", (Object)e.getMessage()));
        }
    }

    public static List setParametersForUpdateLOB(ICommand command) {
        LinkedList modifyParams;
        block3: {
            block2: {
                modifyParams = null;
                if (!(command instanceof IInsert)) break block2;
                List originalParams = ((IInsert)command).getValues();
                modifyParams = new LinkedList(originalParams);
                Iterator iter = modifyParams.iterator();
                while (iter.hasNext()) {
                    ILiteral param;
                    Class<?> paramClass;
                    if ((class$java$util$List == null ? JDBCExecutionHelper.class$("java.util.List") : class$java$util$List).isAssignableFrom(paramClass = (param = (ILiteral)iter.next()).getValue().getClass()) || (class$java$sql$Blob == null ? JDBCExecutionHelper.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom(paramClass) || (class$java$sql$Clob == null ? JDBCExecutionHelper.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(paramClass)) continue;
                    iter.remove();
                }
                break block3;
            }
            if (!(command instanceof IUpdate)) break block3;
            List originalParams = ((IUpdate)command).getChanges();
            modifyParams = new LinkedList(originalParams);
            Iterator iter = modifyParams.iterator();
            while (iter.hasNext()) {
                ICompareCriteria param;
                Object right;
                Class<?> rightClass;
                if ((class$java$util$List == null ? JDBCExecutionHelper.class$("java.util.List") : class$java$util$List).isAssignableFrom(rightClass = (right = ((ILiteral)(param = (ICompareCriteria)iter.next()).getRightExpression()).getValue()).getClass()) || (class$java$sql$Blob == null ? JDBCExecutionHelper.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom(rightClass) || (class$java$sql$Clob == null ? JDBCExecutionHelper.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(rightClass)) continue;
                iter.remove();
            }
        }
        return modifyParams;
    }

    public static Map createParameterIndexMap(List parameters, String sql) {
        IParameter param;
        if (parameters == null || parameters.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<IParameter, Integer> paramsIndexes = new HashMap<IParameter, Integer>();
        int index = 1;
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            param = (IParameter)iter.next();
            if (param.getDirection() != 3) continue;
            paramsIndexes.put(param, new Integer(index++));
            break;
        }
        iter = parameters.iterator();
        while (iter.hasNext()) {
            param = (IParameter)iter.next();
            if (param.getDirection() == 4 || param.getDirection() == 3) continue;
            paramsIndexes.put(param, new Integer(index++));
        }
        return paramsIndexes;
    }

    public static Class[] getColumnDataTypes(List params, RuntimeMetadata metadata) throws ConnectorException {
        if (params != null) {
            IParameter resultSet = null;
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                IParameter param = (IParameter)iter.next();
                if (param.getDirection() != 4) continue;
                resultSet = param;
                break;
            }
            if (resultSet != null) {
                List columnMetadata = null;
                columnMetadata = resultSet.getMetadataID().getChildIDs();
                int size = columnMetadata.size();
                Class[] coulmnDTs = new Class[size];
                for (int i = 0; i < size; ++i) {
                    MetadataID mID = (MetadataID)columnMetadata.get(i);
                    MetadataObject mObj = metadata.getObject(mID);
                    coulmnDTs[i] = ((Element)mObj).getJavaType();
                }
                return coulmnDTs;
            }
        }
        return new Class[0];
    }

    public static Object convertValue(Object value, Class expectedType, List valueTranslators, boolean trimStrings, ExecutionContext context) throws ConnectorException {
        if (expectedType.isAssignableFrom(value.getClass())) {
            return value;
        }
        ValueTranslator translator = JDBCExecutionHelper.determineTransformation(value.getClass(), expectedType, valueTranslators);
        Object result = translator.translate(value, context);
        if (trimStrings && result instanceof String) {
            result = ((String)result).trim();
        }
        return result;
    }

    private static Object modifyTimeZone(Object value, TimeZone dbmsTimeZone) {
        if (value instanceof TimestampWithTimezone) {
            TimestampWithTimezone tsTz = (TimestampWithTimezone)value;
            if (dbmsTimeZone != null) {
                tsTz.changeTimeZone(dbmsTimeZone);
            }
            return tsTz.createTimestamp();
        }
        if (dbmsTimeZone != null && value instanceof java.util.Date) {
            TimestampWithTimezone tsTz = new TimestampWithTimezone((java.util.Date)value, LOCAL_TIME_ZONE);
            tsTz.changeTimeZone(dbmsTimeZone);
            if (value instanceof Timestamp) {
                return tsTz.createTimestamp();
            }
            if (value instanceof Date) {
                return tsTz.createDate();
            }
            if (value instanceof Time) {
                return tsTz.createTime();
            }
        }
        return value;
    }

    protected static ValueTranslator determineTransformation(Class actualType, Class expectedType, List valueTranslators) throws ConnectorException {
        ValueTranslator valueTranslator = null;
        if (valueTranslators != null && !valueTranslators.isEmpty()) {
            Iterator iter = valueTranslators.iterator();
            while (iter.hasNext()) {
                ValueTranslator translator = (ValueTranslator)iter.next();
                if (!expectedType.equals(translator.getTargetType()) || !translator.getSourceType().isAssignableFrom(actualType)) continue;
                valueTranslator = translator;
                break;
            }
        }
        if (valueTranslator == null) {
            Transform transform = DataTypeManager.getTransform((Class)actualType, (Class)expectedType);
            if (transform == null) {
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCTranslator.Unable_to_translate_data_value__11", (Object)actualType.getName(), (Object)expectedType.getName()));
            }
            valueTranslator = new ValueTranslatorAdaptor(transform);
        }
        return valueTranslator;
    }

    private static List breakSetCriteria(IInCriteria setCriteria, int batchSize, ILanguageFactory langFactory) {
        ArrayList<IInCriteria> crits = new ArrayList<IInCriteria>();
        List values = setCriteria.getRightExpressions();
        int numValues = values.size();
        for (int i = 0; i < numValues; i += batchSize) {
            IInCriteria subCrit = langFactory.createInCriteria(setCriteria.getLeftExpression(), null, false);
            if (i + batchSize > numValues) {
                subCrit.setRightExpressions(values.subList(i, numValues));
            } else {
                subCrit.setRightExpressions(values.subList(i, i + batchSize));
            }
            crits.add(subCrit);
        }
        return crits;
    }

    static String trimString(String value) {
        for (int i = value.length() - 1; i >= 0; --i) {
            if (value.charAt(i) == ' ') continue;
            return value.substring(0, i + 1);
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

