/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sybase;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.sybase.FormatTimestampModifier;
import com.metamatrix.connector.jdbc.sybase.ModFunctionModifier;
import com.metamatrix.connector.jdbc.sybase.SubstringFunctionModifier;
import com.metamatrix.connector.jdbc.sybase.SybaseConvertModifier;
import com.metamatrix.connector.jdbc.sybase.SybaseSQLConversionVisitor;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SybaseSQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        this.connectorProperties = this.getConnectorEnvironment().getProperties();
        this.languageFactory = this.getConnectorEnvironment().getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("mod", new ModFunctionModifier());
        this.functionModifiers.put("chr", new AliasModifier("char"));
        this.functionModifiers.put("concat", new AliasModifier("+"));
        this.functionModifiers.put("||", new AliasModifier("+"));
        this.functionModifiers.put("lcase", new AliasModifier("lower"));
        this.functionModifiers.put("length", new AliasModifier("char_length"));
        this.functionModifiers.put("ifnull", new AliasModifier("isnull"));
        this.functionModifiers.put("ucase", new AliasModifier("upper"));
        this.functionModifiers.put("nvl", new AliasModifier("isnull"));
        this.functionModifiers.put("substring", new SubstringFunctionModifier(this.languageFactory));
        this.functionModifiers.put("cast", new SybaseConvertModifier(this.languageFactory));
        this.functionModifiers.put("convert", new SybaseConvertModifier(this.languageFactory));
        this.functionModifiers.put("formattimestamp", new FormatTimestampModifier(this.languageFactory));
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        SybaseSQLConversionVisitor visitor = new SybaseSQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }
}

