/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sqlserver;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageObject;
import java.sql.Time;

public class SqlServerSQLConversionVisitor
extends SQLConversionVisitor {
    private final int MAX_SELECT_ALIAS_LENGTH = 30;
    private final int MAX_TABLE_ALIAS_LENGTH = 128;

    public void visit(IFunction obj) {
        if (obj.getName().equals("%")) {
            String name = obj.getName();
            IExpression[] args = obj.getParameters();
            this.buffer.append("(");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this.append((ILanguageObject)args[i]);
                    if (i >= args.length - 1) continue;
                    this.buffer.append(" ");
                    this.buffer.append(name);
                    this.buffer.append(" ");
                }
            }
            this.buffer.append(")");
        } else {
            super.visit(obj);
        }
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{ts'1900-01-01 " + this.formatDateValue(timeValue) + "'}";
    }

    protected int getMaxSelectAliasLength() {
        return 30;
    }

    protected int getMaxTableAliasLength() {
        return 128;
    }
}

