/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class BasicSQLTranslator
implements SQLTranslator {
    private RuntimeMetadata metadata;
    private ConnectorEnvironment environment;
    private Map functionModifiers = new HashMap();
    private TimeZone databaseTimeZone;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        this.metadata = metadata;
        this.environment = env;
        String timeZone = env.getProperties().getProperty("DatabaseTimeZone");
        if (timeZone != null && timeZone.trim().length() > 0) {
            this.databaseTimeZone = TimeZone.getTimeZone(timeZone);
        }
    }

    public ICommand modifyCommand(ICommand command, ExecutionContext context) throws ConnectorException {
        return command;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        SQLConversionVisitor visitor = new SQLConversionVisitor();
        visitor.setRuntimeMetadata(this.metadata);
        visitor.setFunctionModifiers(this.getFunctionModifiers());
        visitor.setProperties(this.environment.getProperties());
        visitor.setLanguageFactory(this.environment.getLanguageFactory());
        visitor.setDatabaseTimeZone(this.databaseTimeZone);
        return visitor;
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    protected RuntimeMetadata getRuntimeMetadata() {
        return this.metadata;
    }

    protected ConnectorEnvironment getConnectorEnvironment() {
        return this.environment;
    }

    protected TimeZone getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }
}

