/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.util.JDBCExecutionHelper;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.IQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TranslatedCommand {
    public static final int EXEC_TYPE_QUERY = 0;
    public static final int EXEC_TYPE_UPDATE = 1;
    public static final int EXEC_TYPE_EXECUTE = 2;
    public static final int STMT_TYPE_STATEMENT = 0;
    public static final int STMT_TYPE_PREPARED_STATEMENT = 1;
    public static final int STMT_TYPE_CALLABLE_STATEMENT = 2;
    private String sql;
    private int executionType;
    private int statementType;
    private List preparedValues;
    private boolean isLargeSetQuery;
    private Collection largeSetQueries;
    private Iterator largeSetQueriesIterator;
    private SQLConversionVisitor sqlConversionVisitor;

    public TranslatedCommand(SQLConversionVisitor visitor) {
        this.sqlConversionVisitor = visitor;
    }

    public void translateCommand(ICommand command) {
        if (JDBCExecutionHelper.isLargeSetQuery(command, this.sqlConversionVisitor.getSetCriteriaBatchSize())) {
            this.isLargeSetQuery = true;
            this.largeSetQueries = JDBCExecutionHelper.getLargeSetSqls((IQuery)command, this.sqlConversionVisitor.getSetCriteriaBatchSize(), this.sqlConversionVisitor.getLanguageFactory());
            this.largeSetQueriesIterator = this.largeSetQueries.iterator();
            this.statementType = 1;
        } else {
            this.sqlConversionVisitor.append((ILanguageObject)command);
            this.sql = this.sqlConversionVisitor.toString();
            this.statementType = this.sqlConversionVisitor.getStmtType();
            this.executionType = this.sqlConversionVisitor.getExecType();
            this.preparedValues = this.sqlConversionVisitor.getPreparedValues();
        }
    }

    public int getExecutionType() {
        return this.executionType;
    }

    public List getPreparedValues() {
        return this.preparedValues;
    }

    public String getSql() {
        return this.sql;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String nextLargeSetQuerySQL() {
        if (this.largeSetQueriesIterator.hasNext()) {
            IQuery query = (IQuery)this.largeSetQueriesIterator.next();
            this.sqlConversionVisitor.reset();
            this.sqlConversionVisitor.append((ILanguageObject)query);
            this.statementType = this.sqlConversionVisitor.getStmtType();
            this.executionType = this.sqlConversionVisitor.getExecType();
            return this.sqlConversionVisitor.toString();
        }
        return null;
    }

    public boolean isLargeSetQuery() {
        return this.isLargeSetQuery;
    }
}

