/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.db2;

import com.metamatrix.data.api.TypeFacility;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DB2SQLModificationVisitor
extends HierarchyVisitor {
    private ILanguageFactory languageFactory;

    public DB2SQLModificationVisitor(ILanguageFactory languageFactory) {
        this.languageFactory = languageFactory;
    }

    private ICriteria rewriteCriteria(ICriteria crit) {
        if (crit instanceof ICompoundCriteria) {
            this.rewriteCompoundCriteria((ICompoundCriteria)crit);
        } else if (crit instanceof INotCriteria) {
            this.rewriteNotCriteria((INotCriteria)crit);
        } else if (crit instanceof ICompareCriteria) {
            IExpression rExpression = ((ICompareCriteria)crit).getRightExpression();
            if (rExpression instanceof ILiteral && ((ILiteral)rExpression).getValue() == null) {
                return this.languageFactory.createCompareCriteria(0, (IExpression)this.languageFactory.createLiteral((Object)new Integer(1), TypeFacility.RUNTIME_TYPES.INTEGER), (IExpression)this.languageFactory.createLiteral((Object)new Integer(0), TypeFacility.RUNTIME_TYPES.INTEGER));
            }
            IExpression lExpression = ((ICompareCriteria)crit).getLeftExpression();
            if (lExpression instanceof ILiteral && ((ILiteral)lExpression).getValue() == null) {
                return this.languageFactory.createCompareCriteria(0, (IExpression)this.languageFactory.createLiteral((Object)new Integer(1), TypeFacility.RUNTIME_TYPES.INTEGER), (IExpression)this.languageFactory.createLiteral((Object)new Integer(0), TypeFacility.RUNTIME_TYPES.INTEGER));
            }
        } else {
            ILikeCriteria like;
            if (crit instanceof IInCriteria) {
                IInCriteria setCrit = (IInCriteria)crit;
                Iterator valuesIter = setCrit.getRightExpressions().iterator();
                ArrayList<ILiteral> newValues = new ArrayList<ILiteral>();
                while (valuesIter.hasNext()) {
                    ILiteral value = (ILiteral)valuesIter.next();
                    if (value.getValue() == null) continue;
                    newValues.add(value);
                }
                if (newValues.size() > 0) {
                    return this.languageFactory.createInCriteria(setCrit.getLeftExpression(), newValues, setCrit.isNegated());
                }
                return this.languageFactory.createCompareCriteria(0, (IExpression)this.languageFactory.createLiteral((Object)new Integer(1), TypeFacility.RUNTIME_TYPES.INTEGER), (IExpression)this.languageFactory.createLiteral((Object)new Integer(0), TypeFacility.RUNTIME_TYPES.INTEGER));
            }
            if (crit instanceof ILikeCriteria && ((like = (ILikeCriteria)crit).getRightExpression() == null || like.getRightExpression() instanceof ILiteral && ((ILiteral)like.getRightExpression()).getValue() == null)) {
                return this.languageFactory.createCompareCriteria(0, (IExpression)this.languageFactory.createLiteral((Object)new Integer(1), TypeFacility.RUNTIME_TYPES.INTEGER), (IExpression)this.languageFactory.createLiteral((Object)new Integer(like.isNegated() ? 1 : 0), TypeFacility.RUNTIME_TYPES.INTEGER));
            }
        }
        return crit;
    }

    private void rewriteCompoundCriteria(ICompoundCriteria obj) {
        List crits = obj.getCriteria();
        ArrayList<ICriteria> newCrits = new ArrayList<ICriteria>(crits.size());
        for (int i = 0; i < crits.size(); ++i) {
            ICriteria crit = (ICriteria)crits.get(i);
            newCrits.add(this.rewriteCriteria(crit));
        }
        obj.setCriteria(newCrits);
    }

    private void rewriteNotCriteria(INotCriteria obj) {
        if (obj.getCriteria() != null) {
            obj.setCriteria(this.rewriteCriteria(obj.getCriteria()));
        }
    }

    public void visit(IDelete obj) {
        if (obj.getCriteria() != null) {
            obj.setCriteria(this.rewriteCriteria(obj.getCriteria()));
        }
    }

    public void visit(IQuery obj) {
        if (obj.getWhere() != null) {
            obj.setWhere(this.rewriteCriteria(obj.getWhere()));
        }
    }

    public void visit(IUpdate obj) {
        if (obj.getCriteria() != null) {
            obj.setCriteria(this.rewriteCriteria(obj.getCriteria()));
        }
    }
}

