/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.JDBCSourceConnectionFactory;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.UserIdentity;
import java.sql.Driver;
import java.util.Properties;

public abstract class JDBCUserIdentityConnectionFactory
extends JDBCSourceConnectionFactory {
    private Driver driver;
    private String url;
    private int transIsoLevel;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        super.initialize(env);
        this.verifyConnectionProperties(env.getProperties());
    }

    public boolean isSingleIdentity() {
        return false;
    }

    protected void verifyConnectionProperties(Properties connectionProps) throws ConnectorException {
        String driverClassName = connectionProps.getProperty("Driver");
        this.driver = this.createDriver(driverClassName);
        this.url = connectionProps.getProperty("URL");
        if (this.url != null && this.url.trim().length() > 0) {
            this.validateURL(this.driver, this.url);
        }
        this.transIsoLevel = this.interpretTransactionIsolationLevel(connectionProps.getProperty("TransactionIsolationLevel"));
    }

    protected String getUrl() {
        return this.url;
    }

    protected int getTransactionIsolationLevel() {
        return this.transIsoLevel;
    }

    public ConnectorIdentity createIdentity(SecurityContext context) throws ConnectorException {
        return new UserIdentity(context);
    }

    public SourceConnection createConnection(ConnectorIdentity id) throws ConnectorException {
        SecurityContext context = id.getSecurityContext();
        String[] userProperties = this.getUserProperties(context);
        Properties props = new Properties();
        props.put("user", userProperties[0]);
        props.put("password", userProperties[1]);
        return this.createJDBCConnection(this.driver, this.getUrl(), this.getTransactionIsolationLevel(), props);
    }

    protected abstract String[] getUserProperties(SecurityContext var1) throws ConnectorException;
}

