/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCBaseExecution;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.data.api.BatchedUpdatesExecution;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.UpdateExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICommand;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;

public class JDBCUpdateExecution
extends JDBCBaseExecution
implements UpdateExecution,
BatchedUpdatesExecution {
    private int updateCount = 0;

    public JDBCUpdateExecution(Connection connection, SQLTranslator sqlTranslator, ResultsTranslator resultsTranslator, ConnectorLogger logger, Properties props, ExecutionContext context) {
        super(connection, sqlTranslator, resultsTranslator, logger, props, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int execute(ICommand command) throws ConnectorException {
        this.command = command;
        if (command instanceof IBulkInsert) {
            return this.execute((IBulkInsert)command);
        }
        TranslatedCommand translatedComm = this.translateCommand(this.command);
        String sql = translatedComm.getSql();
        try {
            List values = translatedComm.getPreparedValues();
            if (values == null) {
                if (translatedComm.getStatementType() == 0) {
                    this.updateCount = this.getStatement().executeUpdate(sql);
                    return this.updateCount;
                } else {
                    if (translatedComm.getStatementType() != 1) throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSynchExecution.Statement_type_not_support_for_command_1", (Object)new Integer(translatedComm.getStatementType()), (Object)sql));
                    this.updateCount = this.getPreparedStatement(sql).executeUpdate();
                }
                return this.updateCount;
            } else {
                if (translatedComm.getStatementType() != 1) {
                    throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSynchExecution.Statement_type_not_support_for_command_1", (Object)new Integer(translatedComm.getStatementType()), (Object)sql));
                }
                this.updateCount = this.resultsTranslator.executeStatementForLargeObjects(this.connection, this.getPreparedStatement(sql), translatedComm);
            }
            return this.updateCount;
        }
        catch (SQLException e) {
            this.logger.logError(JDBCPlugin.Util.getString("JDBCQueryExecution.Error_executing_query__1", (Object)sql));
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
    }

    public int[] execute(ICommand[] commands) throws ConnectorException {
        TranslatedCommand command = null;
        boolean exceptionOccurred = false;
        boolean commitType = this.getAutoCommit("");
        try {
            if (commitType) {
                this.connection.setAutoCommit(false);
            }
            Statement stmt = this.getStatement();
            for (int i = 0; i < commands.length; ++i) {
                command = this.translateCommand(commands[i]);
                if (command.getStatementType() == 2) {
                    throw new ConnectorException(JDBCPlugin.Util.getString("JDBCUpdateExecution.batch_stored_proc"));
                }
                if (command.getPreparedValues() != null) {
                    throw new ConnectorException(JDBCPlugin.Util.getString("JDBCUpdateExecution.batch_prep_stmt"));
                }
                stmt.addBatch(command.getSql());
            }
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            exceptionOccurred = true;
            throw this.logAndBuildConnectorException(e, "");
        }
        finally {
            if (commitType) {
                this.restoreAutoCommit(exceptionOccurred, "");
            }
        }
    }

    public int execute(IBulkInsert command) throws ConnectorException {
        this.command = command;
        boolean exceptionOccurred = false;
        TranslatedCommand translatedComm = this.translateCommand(this.command);
        String sql = translatedComm.getSql();
        boolean commitType = this.getAutoCommit(sql);
        try {
            if (commitType) {
                this.connection.setAutoCommit(false);
            }
            Statement stmt = this.getStatement();
            this.updateCount = this.resultsTranslator.executeStatementForBulkInsert(this.connection, stmt, translatedComm);
        }
        catch (SQLException e) {
            exceptionOccurred = true;
            throw this.logAndBuildConnectorException(e, sql);
        }
        finally {
            if (commitType) {
                this.restoreAutoCommit(exceptionOccurred, sql);
            }
        }
        return this.updateCount;
    }

    private boolean getAutoCommit(String sql) throws ConnectorException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw this.logAndBuildConnectorException(e, sql);
        }
    }

    private void restoreAutoCommit(boolean exceptionOccurred, String sql) throws ConnectorException {
        try {
            if (exceptionOccurred) {
                this.connection.rollback();
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw this.logAndBuildConnectorException(e, sql);
        }
    }

    private ConnectorException logAndBuildConnectorException(SQLException e, String sql) {
        this.logger.logError(JDBCPlugin.Util.getString("JDBCQueryExecution.Error_executing_query__1", (Object)sql));
        return new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
    }
}

